/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.server;

import java.net.URI;
import java.nio.file.Paths;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.server.HtmlApplicationHttpHandler;
import net.krotscheck.kangaroo.test.NetworkUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public final class HtmlApplicationHttpHandlerTest {
    private static HttpServer server;
    private static String port;

    @BeforeClass
    public static void startServer() throws Exception {
        port = String.valueOf(NetworkUtil.findFreePort());
        URI serverUri = UriBuilder.fromUri((String)("http://localhost:" + port + "/")).build(new Object[0]);
        String appRoot = Paths.get("src/test/resources/html/index", new String[0]).toAbsolutePath().toString();
        server = GrizzlyHttpServerFactory.createHttpServer((URI)serverUri, (boolean)false);
        HtmlApplicationHttpHandler handler = new HtmlApplicationHttpHandler(appRoot);
        server.getServerConfiguration().addHttpHandler((HttpHandler)handler, new String[]{"/*"});
        server.start();
    }

    @AfterClass
    public static void stopServer() {
        server.shutdownNow();
        server = null;
    }

    private CloseableHttpClient getHttpClient() throws Exception {
        return HttpClients.createDefault();
    }

    @Test(expected=RuntimeException.class)
    public void handleCreateWithInvalidRoot() throws Exception {
        String appRoot = Paths.get("src/test/resources/html/noindex", new String[0]).toAbsolutePath().toString();
        new HtmlApplicationHttpHandler(appRoot);
    }

    @Test
    public void handleReadIndex() throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet1 = new HttpGet("http://localhost:" + port + "/index.html");
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet1);
        String responseBody1 = EntityUtils.toString((HttpEntity)response.getEntity());
        response.close();
        Assert.assertEquals((long)response.getStatusLine().getStatusCode(), (long)200L);
        Assert.assertEquals((Object)"Hello world", (Object)responseBody1);
        httpclient.close();
    }

    @Test
    public void handleReadRootPath() throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet1 = new HttpGet("http://localhost:" + port);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet1);
        String responseBody1 = EntityUtils.toString((HttpEntity)response.getEntity());
        response.close();
        Assert.assertEquals((long)response.getStatusLine().getStatusCode(), (long)200L);
        Assert.assertEquals((Object)"Hello world", (Object)responseBody1);
        httpclient.close();
    }

    @Test
    public void handleValidSubdirectory() throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet1 = new HttpGet("http://localhost:" + port + "/subdir/");
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet1);
        String responseBody1 = EntityUtils.toString((HttpEntity)response.getEntity());
        response.close();
        Assert.assertEquals((long)response.getStatusLine().getStatusCode(), (long)200L);
        Assert.assertEquals((Object)"Hello world", (Object)responseBody1);
        httpclient.close();
    }

    @Test
    public void handle404Resource() throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet1 = new HttpGet("http://localhost:" + port + "/invalid.html");
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet1);
        String responseBody1 = EntityUtils.toString((HttpEntity)response.getEntity());
        response.close();
        Assert.assertEquals((long)response.getStatusLine().getStatusCode(), (long)200L);
        Assert.assertEquals((Object)"Hello world", (Object)responseBody1);
        httpclient.close();
    }

    @Test
    public void handleValidSubresource() throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet1 = new HttpGet("http://localhost:" + port + "/subdir/other.html");
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet1);
        String responseBody1 = EntityUtils.toString((HttpEntity)response.getEntity());
        response.close();
        Assert.assertEquals((long)response.getStatusLine().getStatusCode(), (long)200L);
        Assert.assertEquals((Object)"Other hello world", (Object)responseBody1);
        httpclient.close();
    }

    @Test
    public void testNonGetResource() throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpDelete httpDelete = new HttpDelete("http://localhost:" + port + "/subdir/other.html");
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpDelete);
        String responseBody1 = EntityUtils.toString((HttpEntity)response.getEntity());
        response.close();
        Assert.assertEquals((long)response.getStatusLine().getStatusCode(), (long)405L);
        httpclient.close();
    }
}

