/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.server;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import net.krotscheck.kangaroo.server.KangarooErrorPageGenerator;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class KangarooErrorPageGeneratorTest {
    private static final ObjectMapper MAPPER = new ObjectMapperFactory().get();

    @Test
    public void assertBasicError() throws Exception {
        KangarooErrorPageGenerator generator = new KangarooErrorPageGenerator();
        Request r = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        ((Request)Mockito.doReturn((Object)response).when((Object)r)).getResponse();
        String body = generator.generate(r, 404, "Not Found", "Not Found", null);
        ErrorResponseBuilder.ErrorResponse decoded = (ErrorResponseBuilder.ErrorResponse)MAPPER.readValue(body, ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"not_found", (Object)decoded.getError());
        Assert.assertEquals((Object)"Not Found", (Object)decoded.getErrorDescription());
        ((Response)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setContentType("application/json");
    }

    @Test
    public void assertMappingError() throws Exception {
        KangarooErrorPageGenerator generator = new KangarooErrorPageGenerator();
        KangarooErrorPageGenerator generatorSpy = (KangarooErrorPageGenerator)Mockito.spy((Object)generator);
        Request r = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        ((Request)Mockito.doReturn((Object)response).when((Object)r)).getResponse();
        ((KangarooErrorPageGenerator)Mockito.doThrow(JsonParseException.class).when((Object)generatorSpy)).getMapper();
        String body = generatorSpy.generate(r, 404, "Not Found", "Not Found", null);
        ErrorResponseBuilder.ErrorResponse decoded = (ErrorResponseBuilder.ErrorResponse)MAPPER.readValue(body, ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"internal_server_error", (Object)decoded.getError());
        Assert.assertEquals((Object)"Internal Server Error", (Object)decoded.getErrorDescription());
        ((Response)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setContentType("application/json");
    }
}

