/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.jackson.ObjectMapperFactory;
import net.krotscheck.kangaroo.common.status.StatusFeature;
import net.krotscheck.kangaroo.server.ServerFactory;
import net.krotscheck.kangaroo.test.NetworkUtil;
import net.krotscheck.kangaroo.test.rule.WorkingDirectoryRule;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public final class ServerFactoryTest {
    @Rule
    public final WorkingDirectoryRule workingDirectory = new WorkingDirectoryRule();

    private CloseableHttpClient getHttpClient() throws Exception {
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    @Test
    public void testSimpleBuild() {
        ServerFactory f = new ServerFactory();
        HttpServer s = f.build();
        Assert.assertNotNull((Object)s);
    }

    @Test(expected=RuntimeException.class)
    public void testBuildInvalidURL() {
        ServerFactory f = new ServerFactory().withCommandlineArgs(new String[]{"-h=!@#$%^&*()", "-p=10000"});
        f.build();
    }

    @Test
    public void testWithProvidedCert() throws Exception {
        Path relativeCertPath = Paths.get("src/test/resources/ssl/test_keystore.p12", new String[0]);
        String certPath = relativeCertPath.toAbsolutePath().toString();
        ServerFactory f = new ServerFactory().withCommandlineArgs(new String[]{"--kangaroo.keystore_path=" + certPath, "--kangaroo.keystore_password=kangaroo", "--kangaroo.keystore_type=PKCS12", "--kangaroo.cert_alias=kangaroo", "--kangaroo.cert_key_password=kangaroo"});
        Assert.assertNotNull((Object)f.build());
    }

    @Test(expected=RuntimeException.class)
    public void testWithInvalidProvidedCert() throws Exception {
        Path relativeCertPath = Paths.get("src/test/resources/ssl/test_keystore.p12", new String[0]);
        String certPath = relativeCertPath.toAbsolutePath().toString();
        ServerFactory f = new ServerFactory().withCommandlineArgs(new String[]{"--kangaroo.keystore_path=" + certPath, "--kangaroo.keystore_password=invalidPass", "--kangaroo.keystore_type=PKCS12", "--kangaroo.cert_alias=kangaroo", "--kangaroo.cert_key_password=kangaroo"});
        f.build();
    }

    @Test
    public void testBuildAllConfigOptions() throws Exception {
        URL filePath = this.getClass().getResource("/config/test.properties");
        String openPort = String.valueOf(NetworkUtil.findFreePort());
        File tempDir = this.workingDirectory.getWorkingDir();
        ServerFactory f = new ServerFactory().withCommandlineArgs(new String[]{"-p=" + openPort, "-h=localhost", "--kangaroo.working_dir=" + tempDir.toString()});
        HttpServer s = f.build();
        s.start();
        File keystore = new File(tempDir, "generated.p12");
        Assert.assertTrue((boolean)keystore.exists());
        s.shutdownNow();
    }

    @Test
    public void testBuildGeneratesKeystore() throws Exception {
        URL filePath = this.getClass().getResource("/config/test.properties");
        String openPort = String.valueOf(NetworkUtil.findFreePort());
        ServerFactory f = new ServerFactory().withCommandlineArgs(new String[]{"-p=" + openPort, "-h=localhost"}).withPropertiesFile(filePath.toString());
        HttpServer s = f.build();
        s.start();
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpGet httpGet = new HttpGet("https://localhost:" + openPort + "/");
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
        Assert.assertEquals((long)response.getStatusLine().getStatusCode(), (long)404L);
        response.close();
        httpclient.close();
        s.shutdownNow();
    }

    @Test
    public void testMountMultipleServlets() throws Exception {
        Path appRoot = Paths.get("src/test/resources/html/index", new String[0]);
        String appPath = appRoot.toAbsolutePath().toString();
        String openPort = String.valueOf(NetworkUtil.findFreePort());
        ResourceConfig one = new ResourceConfig();
        one.register(StatusFeature.class);
        ResourceConfig two = new ResourceConfig();
        two.register(StatusFeature.class);
        ServerFactory f = new ServerFactory().withCommandlineArgs(new String[]{"--kangaroo.html_app_root=" + appPath, "--kangaroo.port=" + openPort}).withResource("/one", one).withResource("/two", two);
        HttpServer s = f.build();
        s.start();
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpGet httpGet1 = new HttpGet("https://localhost:" + openPort + "/one/status");
        CloseableHttpResponse response1 = httpclient.execute((HttpUriRequest)httpGet1);
        Assert.assertEquals((long)response1.getStatusLine().getStatusCode(), (long)200L);
        response1.close();
        HttpGet httpGet2 = new HttpGet("https://localhost:" + openPort + "/two/status");
        CloseableHttpResponse response2 = httpclient.execute((HttpUriRequest)httpGet2);
        Assert.assertEquals((long)response2.getStatusLine().getStatusCode(), (long)200L);
        response2.close();
        HttpGet httpGet3 = new HttpGet("https://localhost:" + openPort + "/");
        CloseableHttpResponse response3 = httpclient.execute((HttpUriRequest)httpGet3);
        String responseBody3 = EntityUtils.toString((HttpEntity)response3.getEntity());
        Assert.assertEquals((long)response3.getStatusLine().getStatusCode(), (long)200L);
        Assert.assertEquals((Object)"Hello world", (Object)responseBody3);
        response3.close();
        httpclient.close();
        s.shutdownNow();
    }

    @Test
    public void testAddHtmlApp() throws Exception {
        Path appRoot = Paths.get("src/test/resources/html/index", new String[0]);
        String appPath = appRoot.toAbsolutePath().toString();
        String openPort = String.valueOf(NetworkUtil.findFreePort());
        ServerFactory f = new ServerFactory().withCommandlineArgs(new String[]{"--kangaroo.html_app_root=" + appPath, "--kangaroo.port=" + openPort});
        HttpServer s = f.build();
        s.start();
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpGet httpGet1 = new HttpGet("https://localhost:" + openPort + "/");
        CloseableHttpResponse response1 = httpclient.execute((HttpUriRequest)httpGet1);
        String responseBody1 = EntityUtils.toString((HttpEntity)response1.getEntity());
        Assert.assertEquals((long)response1.getStatusLine().getStatusCode(), (long)200L);
        Assert.assertEquals((Object)"Hello world", (Object)responseBody1);
        response1.close();
        httpclient.close();
        s.shutdownNow();
    }

    @Test
    public void testConfigureServer() throws Exception {
        ServerFactory f = new ServerFactory().configureServer(s -> s.getServerConfiguration().setSessionTimeoutSeconds(1000));
        HttpServer s2 = f.build();
        Assert.assertEquals((long)1000L, (long)s2.getServerConfiguration().getSessionTimeoutSeconds());
    }

    @Test
    public void testNoGrizzlyServer() throws Exception {
        String openPort = String.valueOf(NetworkUtil.findFreePort());
        ResourceConfig one = new ResourceConfig();
        one.register(StatusFeature.class);
        ServerFactory f = new ServerFactory().withCommandlineArgs(new String[]{"--kangaroo.port=" + openPort}).withResource("/one", one);
        HttpServer s = f.build();
        s.start();
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpGet httpGet1 = new HttpGet("https://localhost:" + openPort + "/one/status");
        CloseableHttpResponse response1 = httpclient.execute((HttpUriRequest)httpGet1);
        Assert.assertEquals((long)response1.getStatusLine().getStatusCode(), (long)200L);
        Assert.assertFalse((boolean)response1.containsHeader("Server"));
        response1.close();
        httpclient.close();
        s.shutdownNow();
    }

    @Test(expected=RuntimeException.class)
    public void testAddHtmlAppWithoutIndex() throws Exception {
        Path appRoot = Paths.get("src/test/resources/html/indnoindexex", new String[0]);
        String appPath = appRoot.toAbsolutePath().toString();
        ServerFactory f = new ServerFactory().withCommandlineArgs(new String[]{"--kangaroo.html_app_root=" + appPath});
        f.build();
    }

    @Test
    public void testCorrectErrorFormat() throws Exception {
        String openPort = String.valueOf(NetworkUtil.findFreePort());
        ResourceConfig one = new ResourceConfig();
        ServerFactory f = new ServerFactory().withCommandlineArgs(new String[]{"--kangaroo.port=" + openPort}).withResource("/one", one);
        ObjectMapper mapper = new ObjectMapperFactory().get();
        HttpServer s = f.build();
        s.start();
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpGet httpGet1 = new HttpGet("https://localhost:" + openPort + "/does/not/exist");
        CloseableHttpResponse response1 = httpclient.execute((HttpUriRequest)httpGet1);
        Assert.assertEquals((long)response1.getStatusLine().getStatusCode(), (long)404L);
        ErrorResponseBuilder.ErrorResponse r = (ErrorResponseBuilder.ErrorResponse)mapper.readValue(response1.getEntity().getContent(), ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((Object)"not_found", (Object)r.getError());
        Assert.assertEquals((Object)"Not Found", (Object)r.getErrorDescription());
        response1.close();
        httpclient.close();
        s.shutdownNow();
    }
}

