/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.server.keystore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import net.krotscheck.kangaroo.server.keystore.FSKeystoreProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public final class FSKeystoreProviderTest {
    private static final String KS_PATH = "src/test/resources/ssl/test_keystore.p12";
    private static final String KS_PASS = "kangaroo";
    private static final String KS_TYPE = "PKCS12";

    @Test
    public void testLoadFile() throws Exception {
        FSKeystoreProvider provider = new FSKeystoreProvider(KS_PATH, KS_PASS, KS_TYPE);
        KeyStore ks = provider.getKeyStore();
        Assert.assertEquals((Object)KS_PASS, (Object)ks.aliases().nextElement());
        Certificate[] chain = ks.getCertificateChain(KS_PASS);
        Assert.assertEquals((long)1L, (long)chain.length);
        X509Certificate cert = (X509Certificate)chain[0];
        Assert.assertNotNull((Object)cert);
        Principal iss = cert.getIssuerDN();
        Principal sub = cert.getSubjectDN();
        Assert.assertEquals((Object)"EMAILADDRESS=krotscheck@gmail.com, CN=localhost, OU=Kangaroo, O=Kangaroo, L=Seattle, ST=Washington, C=US", (Object)iss.getName());
        Assert.assertEquals((Object)"EMAILADDRESS=krotscheck@gmail.com, CN=localhost, OU=Kangaroo, O=Kangaroo, L=Seattle, ST=Washington, C=US", (Object)sub.getName());
    }

    @Test
    public void getKeystoreSingleton() throws Exception {
        FSKeystoreProvider provider = new FSKeystoreProvider(KS_PATH, KS_PASS, KS_TYPE);
        KeyStore ks1 = provider.getKeyStore();
        KeyStore ks2 = provider.getKeyStore();
        Assert.assertSame((Object)ks1, (Object)ks2);
    }

    @Test(expected=RuntimeException.class)
    public void testLoadNonexistentFile() {
        FSKeystoreProvider provider = new FSKeystoreProvider("", KS_PASS, KS_TYPE);
        provider.getKeyStore();
    }

    @Test(expected=RuntimeException.class)
    public void testLoadBadPassword() {
        FSKeystoreProvider provider = new FSKeystoreProvider(KS_PATH, "invalid", KS_TYPE);
        provider.getKeyStore();
    }

    @Test(expected=RuntimeException.class)
    public void testLoadBadType() {
        FSKeystoreProvider provider = new FSKeystoreProvider(KS_PATH, KS_PASS, "INVALID");
        provider.getKeyStore();
    }

    @Test
    public void testWriteTo() throws Exception {
        FSKeystoreProvider provider = new FSKeystoreProvider(KS_PATH, KS_PASS, KS_TYPE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        provider.writeTo((OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        KeyStore keyStore = KeyStore.getInstance(KS_TYPE);
        keyStore.load(bais, KS_PASS.toCharArray());
        Assert.assertEquals((Object)KS_PASS, (Object)keyStore.aliases().nextElement());
    }

    @Test(expected=RuntimeException.class)
    public void testRecastExceptionWriteTo() throws Exception {
        FSKeystoreProvider provider = (FSKeystoreProvider)Mockito.spy((Object)new FSKeystoreProvider(KS_PATH, KS_PASS, KS_TYPE));
        KeyStore mockStore = (KeyStore)Mockito.mock(KeyStore.class);
        ((KeyStore)Mockito.doThrow(Exception.class).when((Object)mockStore)).store((OutputStream)ArgumentMatchers.any(), (char[])ArgumentMatchers.any());
        Mockito.when((Object)provider.getKeyStore()).thenReturn((Object)mockStore);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        provider.writeTo((OutputStream)baos);
    }
}

