/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.server.keystore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import junit.framework.TestCase;
import net.krotscheck.kangaroo.server.keystore.GeneratedKeystoreProvider;
import net.krotscheck.kangaroo.test.rule.WorkingDirectoryRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public final class GeneratedKeystoreProviderTest {
    @Rule
    public final WorkingDirectoryRule workingDirectory = new WorkingDirectoryRule();
    private GeneratedKeystoreProvider provider;

    @Before
    public void setUp() {
        File tempDir = this.workingDirectory.getWorkingDir();
        this.provider = (GeneratedKeystoreProvider)Mockito.spy((Object)new GeneratedKeystoreProvider(tempDir.getAbsolutePath()));
    }

    @Test
    public void testGeneratedFile() {
        File tempDir = this.workingDirectory.getWorkingDir();
        this.provider.getKeyStore();
        File generatedKeystore = new File(tempDir, "generated.p12");
        TestCase.assertTrue((boolean)generatedKeystore.exists());
        TestCase.assertTrue((boolean)generatedKeystore.isFile());
    }

    @Test
    public void testReuseKeystore() throws Exception {
        File tempDir = this.workingDirectory.getWorkingDir();
        this.provider.getKeyStore();
        GeneratedKeystoreProvider provider2 = new GeneratedKeystoreProvider(tempDir.getAbsolutePath());
        RSAPrivateKey key1 = (RSAPrivateKey)this.provider.getKeyStore().getKey("kangaroo", "kangaroo".toCharArray());
        RSAPrivateKey key2 = (RSAPrivateKey)provider2.getKeyStore().getKey("kangaroo", "kangaroo".toCharArray());
        TestCase.assertEquals((Object)key1.getModulus(), (Object)key2.getModulus());
    }

    @Test(expected=RuntimeException.class)
    public void testCannotReuseKeystore() throws Exception {
        File tempDir = this.workingDirectory.getWorkingDir();
        GeneratedKeystoreProvider provider2 = new GeneratedKeystoreProvider(tempDir.getAbsolutePath(), "otherpassword", "otherpassword", "otheralias");
        provider2.getKeyStore();
        this.provider.getKeyStore();
    }

    @Test
    public void validateCertificates() throws Exception {
        Certificate[] chain = this.provider.getKeyStore().getCertificateChain("kangaroo");
        TestCase.assertEquals((int)1, (int)chain.length);
        X509Certificate cert = (X509Certificate)chain[0];
        Assert.assertNotNull((Object)cert);
        Principal iss = cert.getIssuerDN();
        Principal sub = cert.getSubjectDN();
        TestCase.assertEquals((String)"CN=localhost, OU=Kangaroo, O=Kangaroo, L=Seattle, ST=Washington, C=US", (String)iss.getName());
        TestCase.assertEquals((String)"CN=localhost, OU=Kangaroo, O=Kangaroo, L=Seattle, ST=Washington, C=US", (String)sub.getName());
    }

    @Test
    public void getKey() throws Exception {
        KeyStore ks = this.provider.getKeyStore();
        RSAPrivateKey key = (RSAPrivateKey)ks.getKey("kangaroo", "kangaroo".toCharArray());
        Certificate[] chain = this.provider.getKeyStore().getCertificateChain("kangaroo");
        TestCase.assertEquals((int)1, (int)chain.length);
        RSAPublicKey pubKey = (RSAPublicKey)chain[0].getPublicKey();
        TestCase.assertEquals((Object)key.getModulus(), (Object)pubKey.getModulus());
    }

    @Test
    public void getKeystoreSingleton() throws Exception {
        KeyStore ks1 = this.provider.getKeyStore();
        KeyStore ks2 = this.provider.getKeyStore();
        Assert.assertSame((Object)ks1, (Object)ks2);
    }

    @Test
    public void testWriteTo() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.provider.getKeyStore();
        this.provider.writeTo((OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(bais, "kangaroo".toCharArray());
        TestCase.assertEquals((String)"kangaroo", (String)keyStore.aliases().nextElement());
    }

    @Test(expected=RuntimeException.class)
    public void testRecastExceptionWriteTo() throws Exception {
        ((GeneratedKeystoreProvider)Mockito.doThrow((Throwable[])new Throwable[]{new NoSuchAlgorithmException()}).when((Object)this.provider)).getCertificateBuilder((KeyPair)ArgumentMatchers.any());
        this.provider.getKeyStore();
    }
}

