/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import java.util.ArrayList;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.LoggerFactory;

public final class LoggingRule
implements TestRule {
    private final Class targetClass;
    private final Level level;
    private DebugAppender activeAppender;

    public LoggingRule(Class targetClass, Level level) {
        this.targetClass = targetClass;
        this.level = level;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Logger classLogger = (Logger)LoggerFactory.getLogger((Class)LoggingRule.this.targetClass);
                LoggingRule.this.activeAppender = new DebugAppender();
                LoggingRule.this.activeAppender.setContext((Context)classLogger.getLoggerContext());
                LoggingRule.this.activeAppender.start();
                Level old = classLogger.getLevel();
                try {
                    classLogger.addAppender((Appender)LoggingRule.this.activeAppender);
                    classLogger.setLevel(LoggingRule.this.level);
                    base.evaluate();
                }
                finally {
                    LoggingRule.this.activeAppender.stop();
                    classLogger.detachAppender((Appender)LoggingRule.this.activeAppender);
                    classLogger.setLevel(old);
                    LoggingRule.this.activeAppender = null;
                }
            }
        };
    }

    public void clear() {
        this.activeAppender.messages.clear();
    }

    public List<String> getMessages() {
        return new ArrayList<String>(this.activeAppender.messages);
    }

    private static class DebugAppender<E>
    extends AppenderBase<E> {
        private final List<String> messages = new ArrayList<String>();

        private DebugAppender() {
        }

        public String getName() {
            return "TEST";
        }

        protected void append(E eventObject) {
            ILoggingEvent event = (ILoggingEvent)eventObject;
            this.messages.add(event.getFormattedMessage());
        }
    }
}

