/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test;

import java.io.File;
import net.krotscheck.kangaroo.test.rule.database.TestDB;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalINIConfiguration;
import org.hibernate.dialect.H2Dialect;

public final class TestConfig {
    private TestConfig() {
    }

    public static TestDB getDatabase() {
        return TestDB.fromDialect(TestConfig.getDbDialect());
    }

    public static String getDbJdbcPath() {
        return System.getProperty("hibernate.connection.url", "jdbc:h2:file:./target/h2.test.db");
    }

    public static String getDbDriver() {
        return System.getProperty("hibernate.connection.driver_class", "org.h2.Driver");
    }

    public static String getDbLogin() {
        return System.getProperty("hibernate.connection.username", "oid");
    }

    public static String getDbPassword() {
        return System.getProperty("hibernate.connection.password", "oid");
    }

    public static String getMariaDBRootUser() {
        String home = System.getProperty("user.home");
        File f = new File(home + "/.my.cnf");
        try {
            HierarchicalINIConfiguration configuration = new HierarchicalINIConfiguration(f);
            return configuration.getSection("client").getString("user");
        }
        catch (ConfigurationException e) {
            return System.getProperty("hibernate.root.user", "root");
        }
    }

    public static String getMariaDBRootPassword() {
        String home = System.getProperty("user.home");
        File f = new File(home + "/.my.cnf");
        try {
            HierarchicalINIConfiguration configuration = new HierarchicalINIConfiguration(f);
            return configuration.getSection("client").getString("password");
        }
        catch (ConfigurationException e) {
            return System.getProperty("hibernate.root.password", "");
        }
    }

    public static String getDbDialect() {
        return System.getProperty("hibernate.dialect", H2Dialect.class.getSimpleName());
    }

    public static String getDbChangelog() {
        return System.getProperty("test.db.changelog", "liquibase/db.changelog-master.yaml");
    }

    public static String getFacebookAppId() {
        return System.getenv("KANGAROO_FB_APP_USR");
    }

    public static String getFacebookAppSecret() {
        return System.getenv("KANGAROO_FB_APP_PSW");
    }

    public static String getGoogleAppId() {
        return System.getenv("KANGAROO_GOOGLE_APP_USR");
    }

    public static String getGoogleAppSecret() {
        return System.getenv("KANGAROO_GOOGLE_APP_PSW");
    }

    public static String getGoogleAccountId() {
        return System.getenv("KANGAROO_GOOGLE_ACCOUNT_USR");
    }

    public static String getGoogleAccountSecret() {
        return System.getenv("KANGAROO_GOOGLE_ACCOUNT_PSW");
    }

    public static String getTestingPort() {
        return "7777";
    }
}

