/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.jersey;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.exception.KangarooException;
import net.krotscheck.kangaroo.test.jersey.KangarooJerseyTest;
import net.krotscheck.kangaroo.test.rule.ActiveSessions;
import net.krotscheck.kangaroo.test.rule.DatabaseResource;
import net.krotscheck.kangaroo.test.rule.HibernateResource;
import net.krotscheck.kangaroo.test.rule.HibernateTestResource;
import net.krotscheck.kangaroo.test.rule.WorkingDirectoryRule;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.SearchFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContainerTest
extends KangarooJerseyTest {
    public static final WorkingDirectoryRule WORKING_DIRECTORY = new WorkingDirectoryRule();
    public static final HibernateResource HIBERNATE_RESOURCE = new HibernateResource();
    private static final List<Response.Status> VALID_REDIRECT_CODES = Arrays.asList(Response.Status.SEE_OTHER, Response.Status.CREATED, Response.Status.MOVED_PERMANENTLY, Response.Status.FOUND);
    private static final DatabaseResource DATABASE_RESOURCE = new DatabaseResource();
    @ClassRule
    public static final TestRule CLASS_RULES = RuleChain.outerRule((TestRule)DATABASE_RESOURCE).around((TestRule)WORKING_DIRECTORY).around((TestRule)HIBERNATE_RESOURCE);
    private final HibernateTestResource hibernate = new HibernateTestResource(HIBERNATE_RESOURCE);
    private final TestName testName = new TestName();
    private final ActiveSessions sessionCount = new ActiveSessions(HIBERNATE_RESOURCE);
    @Rule
    public final TestRule instanceRules = RuleChain.outerRule((TestRule)this.testName).around((TestRule)this.sessionCount).around((TestRule)this.hibernate);
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Before
    public final void logTestName() {
        this.logger.info(this.testName.getMethodName());
    }

    public final SessionFactory getSessionFactory() {
        return HIBERNATE_RESOURCE.getSessionFactory();
    }

    public final Session getSession() {
        return this.hibernate.getSession();
    }

    public final SearchFactory getSearchFactory() {
        return this.hibernate.getSearchFactory();
    }

    public final FullTextSession getFullTextSession() {
        return this.hibernate.getFullTextSession();
    }

    protected final Response followRedirect(Response original) {
        return this.followRedirect(original, null);
    }

    protected final Response followRedirect(Response original, String authHeader) {
        Cookie c = (Cookie)original.getCookies().get("kangaroo");
        return this.followRedirect(original, authHeader, c);
    }

    protected final Response followRedirect(Response original, String authHeader, Cookie cookie) {
        Assert.assertTrue((boolean)VALID_REDIRECT_CODES.contains(Response.Status.fromStatusCode((int)original.getStatus())));
        URI uri = original.getLocation();
        WebTarget target = this.target().path(uri.getPath());
        for (NameValuePair pair : URLEncodedUtils.parse((URI)uri, (String)"UTF-8")) {
            target = target.queryParam(pair.getName(), new Object[]{pair.getValue()});
        }
        Invocation.Builder b = target.request();
        if (cookie != null) {
            b.cookie(cookie.getName(), cookie.getValue());
        }
        if (authHeader != null) {
            b.header("Authorization", (Object)authHeader);
        }
        return b.get();
    }

    protected final void assertErrorResponse(Response r, WebApplicationException expectedException) {
        ErrorResponseBuilder.ErrorResponse response = ErrorResponseBuilder.from((WebApplicationException)expectedException).buildEntity();
        this.assertErrorResponse(r, response.getHttpStatus(), response.getError(), response.getErrorDescription());
    }

    protected final void assertErrorResponse(Response r, KangarooException expectedException) {
        ErrorResponseBuilder.ErrorResponse response = ErrorResponseBuilder.from((KangarooException)expectedException).buildEntity();
        this.assertErrorResponse(r, response.getHttpStatus(), response.getError(), response.getErrorDescription());
    }

    protected final void assertErrorResponse(Response r, Response.Status expectedHttpStatus) {
        String expectedError = expectedHttpStatus.getReasonPhrase().toLowerCase().replace(" ", "_");
        String expectedMessage = "HTTP " + expectedHttpStatus.getStatusCode() + ' ' + expectedHttpStatus.getReasonPhrase();
        this.assertErrorResponse(r, expectedHttpStatus, expectedError, expectedMessage);
    }

    protected final void assertErrorResponse(Response r, Response.Status expectedHttpStatus, String expectedError) {
        String expectedMessage = "HTTP " + expectedHttpStatus.getStatusCode() + ' ' + expectedHttpStatus.getReasonPhrase();
        this.assertErrorResponse(r, expectedHttpStatus.getStatusCode(), expectedError, expectedMessage);
    }

    protected final void assertErrorResponse(Response r, Response.Status expectedHttpStatus, String expectedError, String expectedMessage) {
        this.assertErrorResponse(r, expectedHttpStatus.getStatusCode(), expectedError, expectedMessage);
    }

    protected final void assertErrorResponse(Response r, int statusCode, String expectedError, String expectedMessage) {
        Assert.assertFalse((String)String.format("%s must not be a success code", r.getStatus()), (r.getStatus() < 400 ? 1 : 0) != 0);
        ErrorResponseBuilder.ErrorResponse response = (ErrorResponseBuilder.ErrorResponse)r.readEntity(ErrorResponseBuilder.ErrorResponse.class);
        Assert.assertEquals((long)statusCode, (long)r.getStatus());
        Assert.assertEquals((Object)expectedError, (Object)response.getError());
        Assert.assertEquals((Object)expectedMessage, (Object)response.getErrorDescription());
    }
}

