/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.jersey;

import javax.servlet.http.HttpServlet;
import net.krotscheck.kangaroo.common.jackson.JacksonFeature;
import net.krotscheck.kangaroo.test.jersey.CsrfProtectionFilter;
import net.krotscheck.kangaroo.test.jersey.KangarooTestContainerFactory;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.JerseyTest;
import org.glassfish.jersey.test.ServletDeploymentContext;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.slf4j.bridge.SLF4JBridgeHandler;

public abstract class KangarooJerseyTest
extends JerseyTest {
    @Rule
    public final TestRule instanceRules = Timeout.seconds((long)10L);

    @BeforeClass
    public static void overrideSystemProperties() {
        System.setProperty("hibernate.c3p0.min_size", "0");
        System.setProperty("hibernate.c3p0.max_size", "5");
    }

    @AfterClass
    public static void cleanupSystemProperties() {
        System.clearProperty("hibernate.c3p0.min_size");
        System.clearProperty("hibernate.c3p0.max_size");
    }

    protected TestContainerFactory getTestContainerFactory() {
        KangarooTestContainerFactory factory = new KangarooTestContainerFactory();
        factory.configureServer(server -> {
            ServerConfiguration c = server.getServerConfiguration();
            c.setSessionTimeoutSeconds(1000);
        });
        return factory;
    }

    protected DeploymentContext configureDeployment() {
        this.forceSet("jersey.config.test.container.port", "0");
        this.forceSet("jersey.config.test.logging.enable", "true");
        this.forceSet("jersey.config.test.logging.dumpEntity", "true");
        return ServletDeploymentContext.forServlet((HttpServlet)new ServletContainer(this.createApplication())).initParam("swagger.context.id", "TestContext").build();
    }

    protected abstract ResourceConfig createApplication();

    protected final void configureClient(ClientConfig config) {
        config.property("jersey.config.client.followRedirects", (Object)false);
        config.register(CsrfProtectionFilter.class);
        config.register(JacksonFeature.class);
    }

    static {
        if (!SLF4JBridgeHandler.isInstalled()) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
    }
}

