/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.jersey;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.servlet.FilterRegistration;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.filter.CsrfProtectionFilter;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpContainer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.ServletDeploymentContext;
import org.glassfish.jersey.test.spi.TestContainer;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.glassfish.jersey.test.spi.TestHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KangarooTestContainerFactory
implements TestContainerFactory {
    private List<ServerOperator> serverLambdas = new ArrayList<ServerOperator>();

    public TestContainer create(URI baseUri, DeploymentContext context) {
        if (!(context instanceof ServletDeploymentContext)) {
            throw new IllegalArgumentException("The deployment context must be an instance of ServletDeploymentContext.");
        }
        KangarooTestContainer container = new KangarooTestContainer(baseUri, (ServletDeploymentContext)context);
        this.serverLambdas.forEach(l -> l.operation(container.getServer()));
        return container;
    }

    public void configureServer(ServerOperator o) {
        this.serverLambdas.add(o);
    }

    private static final class KangarooTestContainer
    implements TestContainer {
        private static final Logger LOGGER = LoggerFactory.getLogger((String)KangarooTestContainer.class.getName());
        private final ServletDeploymentContext deploymentContext;
        private URI baseUri;
        private HttpServer server;

        private KangarooTestContainer(URI baseUri, ServletDeploymentContext context) {
            this.baseUri = UriBuilder.fromUri((URI)baseUri).path(context.getContextPath()).path(context.getServletPath()).build(new Object[0]);
            LOGGER.info("Creating KangarooTestContainer configured at the base URI " + TestHelper.zeroPortToAvailablePort((URI)baseUri));
            this.deploymentContext = context;
            this.instantiateGrizzlyWebServer();
        }

        public HttpServer getServer() {
            return this.server;
        }

        public ClientConfig getClientConfig() {
            ClientConfig c = new ClientConfig();
            c.property("jersey.config.client.followRedirects", (Object)false);
            c.register(CsrfProtectionFilter.class);
            return c;
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public void start() {
            if (this.server.isStarted()) {
                LOGGER.warn("Ignoring start request - KangarooTestContainer is already started.");
            } else {
                LOGGER.debug("Starting KangarooTestContainer...");
                try {
                    this.server.start();
                    if (this.baseUri.getPort() == 0) {
                        this.baseUri = UriBuilder.fromUri((URI)this.baseUri).port(this.server.getListener("grizzly").getPort()).build(new Object[0]);
                        LOGGER.info("Started KangarooTestContainer at the base URI " + this.baseUri);
                    }
                }
                catch (IOException ioe) {
                    throw new TestContainerException((Throwable)ioe);
                }
            }
        }

        public void stop() {
            if (this.server.isStarted()) {
                LOGGER.debug("Stopping KangarooTestContainer...");
                this.server.shutdownNow();
            } else {
                LOGGER.warn("Ignoring stop request - KangarooTestContainer is already stopped.");
            }
        }

        private void instantiateGrizzlyWebServer() {
            String servletPathLocal;
            String contextPathLocal = this.deploymentContext.getContextPath();
            if (!contextPathLocal.isEmpty() && !contextPathLocal.startsWith("/")) {
                contextPathLocal = "/" + contextPathLocal;
            }
            if (!(servletPathLocal = this.deploymentContext.getServletPath()).startsWith("/")) {
                servletPathLocal = "/" + servletPathLocal;
            }
            servletPathLocal = servletPathLocal.endsWith("/") ? servletPathLocal + "*" : servletPathLocal + "/*";
            WebappContext context = new WebappContext("TestContext", contextPathLocal);
            HttpServlet servletInstance = this.deploymentContext.getServletInstance();
            Class servletClass = this.deploymentContext.getServletClass();
            if (servletInstance != null || servletClass != null) {
                ServletRegistration registration = servletInstance != null ? context.addServlet("TestContext", (Servlet)servletInstance) : context.addServlet("TestContext", servletClass);
                registration.setInitParameters(this.deploymentContext.getInitParams());
                registration.addMapping(new String[]{servletPathLocal});
            }
            for (Iterator eventListener : this.deploymentContext.getListeners()) {
                context.addListener((Class)((Object)eventListener));
            }
            Map contextParams = this.deploymentContext.getContextParams();
            for (String contextParamName : contextParams.keySet()) {
                context.addContextInitParameter(contextParamName, (String)contextParams.get(contextParamName));
            }
            if (this.deploymentContext.getFilters() != null) {
                for (ServletDeploymentContext.FilterDescriptor filterDescriptor : this.deploymentContext.getFilters()) {
                    FilterRegistration filterRegistration = context.addFilter(filterDescriptor.getFilterName(), filterDescriptor.getFilterClass());
                    filterRegistration.setInitParameters(filterDescriptor.getInitParams());
                    filterRegistration.addMappingForUrlPatterns(this.grizzlyDispatcherTypes(filterDescriptor.getDispatcherTypes()), true, new String[]{servletPathLocal});
                }
            }
            try {
                this.server = GrizzlyHttpServerFactory.createHttpServer((URI)this.baseUri, (GrizzlyHttpContainer)null, (boolean)false, null, (boolean)false);
                context.deploy(this.server);
            }
            catch (ProcessingException ex) {
                throw new TestContainerException((Throwable)ex);
            }
        }

        private EnumSet<DispatcherType> grizzlyDispatcherTypes(Set<DispatcherType> dispatcherTypes) {
            HashSet<DispatcherType> grizzlyDispatcherTypes = new HashSet<DispatcherType>();
            for (DispatcherType dispatcherType : dispatcherTypes) {
                grizzlyDispatcherTypes.add(DispatcherType.valueOf((String)dispatcherType.name()));
            }
            return EnumSet.copyOf(grizzlyDispatcherTypes);
        }
    }

    public static interface ServerOperator {
        public void operation(HttpServer var1);
    }
}

