/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.jersey;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.spi.TestContainer;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.junit.Test;

public final class SingletonTestContainerFactory
implements TestContainerFactory {
    private final TestContainerFactory defaultFactory;
    private int testCount = 0;
    private TestContainer currentContainer;

    public SingletonTestContainerFactory(TestContainerFactory defaultFactory, Class testClass) {
        this.defaultFactory = defaultFactory;
        List<Method> methods = SingletonTestContainerFactory.getMethodsAnnotatedWith(testClass, Test.class);
        this.testCount = methods.size();
    }

    public static List<Method> getMethodsAnnotatedWith(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> klass = type; klass != Object.class; klass = klass.getSuperclass()) {
            ArrayList<Method> allMethods = new ArrayList<Method>(Arrays.asList(klass.getDeclaredMethods()));
            for (Method method : allMethods) {
                if (!method.isAnnotationPresent(annotation)) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public TestContainer create(URI baseUri, DeploymentContext deploymentContext) {
        if (this.currentContainer == null) {
            TestContainer created = this.defaultFactory.create(baseUri, deploymentContext);
            this.currentContainer = new SingletonTestContainer(created, this.testCount);
        }
        return this.currentContainer;
    }

    private static class SingletonTestContainer
    implements TestContainer {
        private final int totalStartsExpected;
        private final TestContainer wrapped;
        private int startRequests = 0;
        private boolean started = false;

        SingletonTestContainer(TestContainer wrapped, int totalStartsExpected) {
            this.wrapped = wrapped;
            this.totalStartsExpected = totalStartsExpected;
        }

        public ClientConfig getClientConfig() {
            return this.wrapped.getClientConfig();
        }

        public URI getBaseUri() {
            return this.wrapped.getBaseUri();
        }

        public void start() {
            ++this.startRequests;
            if (!this.started) {
                this.wrapped.start();
                this.started = true;
            }
        }

        public void stop() {
            if (this.startRequests == this.totalStartsExpected) {
                this.wrapped.stop();
                this.started = false;
            }
        }
    }
}

