/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.rule;

import com.mchange.v2.c3p0.PooledDataSource;
import java.sql.SQLException;
import net.krotscheck.kangaroo.test.rule.HibernateResource;
import org.hibernate.c3p0.internal.C3P0ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.service.internal.SessionFactoryServiceRegistryImpl;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class ActiveSessions
implements TestRule {
    private final HibernateResource hibernateResource;

    public ActiveSessions(HibernateResource hibernateResource) {
        this.hibernateResource = hibernateResource;
    }

    private PooledDataSource getDataSource() {
        SessionFactoryImpl sfi = (SessionFactoryImpl)this.hibernateResource.getSessionFactory();
        SessionFactoryServiceRegistryImpl src = (SessionFactoryServiceRegistryImpl)sfi.getServiceRegistry();
        C3P0ConnectionProvider cp = (C3P0ConnectionProvider)src.getService(ConnectionProvider.class);
        return (PooledDataSource)cp.unwrap(PooledDataSource.class);
    }

    private void check() {
        PooledDataSource ds = this.getDataSource();
        int unclosedOrphaned = 0;
        try {
            unclosedOrphaned = ds.getNumUnclosedOrphanedConnectionsDefaultUser();
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((String)String.format("%s Orphaned Connections found", unclosedOrphaned), (long)0L, (long)unclosedOrphaned);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ActiveSessions.this.check();
                base.evaluate();
                ActiveSessions.this.check();
            }
        };
    }
}

