/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.rule;

import java.sql.Connection;
import java.util.TimeZone;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import net.krotscheck.kangaroo.test.TestConfig;
import net.krotscheck.kangaroo.test.rule.database.H2TestDatabase;
import net.krotscheck.kangaroo.test.rule.database.ITestDatabase;
import net.krotscheck.kangaroo.test.rule.database.MariaDBTestDatabase;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class DatabaseResource
implements TestRule {
    private ITestDatabase database;

    public ITestDatabase createDatabase() {
        switch (TestConfig.getDatabase()) {
            case MARIADB: {
                this.database = new MariaDBTestDatabase();
                break;
            }
            default: {
                this.database = new H2TestDatabase();
            }
        }
        this.database.create();
        return this.database;
    }

    public ITestDatabase getDatabase() {
        return this.database;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try (ITestDatabase db = DatabaseResource.this.createDatabase();
                     Connection c = db.getConnection();){
                    JdbcConnection connection = new JdbcConnection(c);
                    Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
                    Liquibase liquibase = new Liquibase(TestConfig.getDbChangelog(), (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
                    liquibase.update(new Contexts());
                    base.evaluate();
                    liquibase.rollback(10000, "");
                }
            }
        };
    }

    static {
        System.setProperty("user.timezone", "UTC");
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }
}

