/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.rule;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.common.httpClient.JerseyClientBuilderFactory;
import net.krotscheck.kangaroo.test.TestConfig;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.glassfish.jersey.client.JerseyClient;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class FacebookTestUser
implements TestRule {
    private final String appId = TestConfig.getFacebookAppId();
    private final String appSecret = TestConfig.getFacebookAppSecret();
    private FBTestUser testUser;

    public String getEmail() {
        return this.testUser.email;
    }

    public String getPassword() {
        return this.testUser.password;
    }

    public String getLoginUrl() {
        return this.testUser.loginUrl;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try (JerseyClient client = null;){
                    client = new JerseyClientBuilderFactory().get().build();
                    FBAuthToken token = FacebookTestUser.this.getAppToken((Client)client);
                    try {
                        FacebookTestUser.this.createFacebookUser((Client)client, token);
                        base.evaluate();
                    }
                    finally {
                        FacebookTestUser.this.deleteFacebookUser((Client)client, token);
                    }
                }
            }
        };
    }

    private void createFacebookUser(Client client, FBAuthToken appToken) {
        URI target = UriBuilder.fromUri((String)"https://graph.facebook.com").path(String.format("/v2.10/%s/accounts/test-users", this.appId)).build(new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("installed", "true");
        params.put("permissions", "public_profile,email");
        Entity postEntity = Entity.entity(params, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        Response r = client.target(target).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((String)appToken.accessToken)).post(postEntity);
        this.testUser = (FBTestUser)r.readEntity(FBTestUser.class);
        r.close();
    }

    private void deleteFacebookUser(Client client, FBAuthToken appToken) {
        URI target = UriBuilder.fromUri((String)"https://graph.facebook.com").path(String.format("/v2.10/%s", this.testUser.id)).build(new Object[0]);
        Response r = client.target(target).request().header("Authorization", (Object)HttpUtil.authHeaderBearer((String)appToken.accessToken)).delete();
        this.testUser = null;
        r.close();
    }

    private FBAuthToken getAppToken(Client client) {
        URI target = UriBuilder.fromUri((String)"https://graph.facebook.com").path("/oauth/access_token").build(new Object[0]);
        Response r = client.target(target).queryParam("client_id", new Object[]{this.appId}).queryParam("client_secret", new Object[]{this.appSecret}).queryParam("grant_type", new Object[]{"client_credentials"}).request().get();
        FBAuthToken token = (FBAuthToken)r.readEntity(FBAuthToken.class);
        r.close();
        return token;
    }

    private static final class FBTestUser {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="access_token")
        private String accessToken;
        @JsonProperty(value="login_url")
        private String loginUrl;
        @JsonProperty(value="email")
        private String email;
        @JsonProperty(value="password")
        private String password;

        private FBTestUser() {
        }
    }

    private static final class FBAuthToken {
        @JsonProperty(value="access_token")
        private String accessToken;
        @JsonProperty(value="token_type")
        private String tokenType;

        private FBAuthToken() {
        }
    }
}

