/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.rule;

import java.io.IOException;
import net.krotscheck.kangaroo.common.hibernate.factory.HibernateServiceRegistryFactory;
import net.krotscheck.kangaroo.common.hibernate.listener.CreatedUpdatedListener;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.SystemConfiguration;
import org.hibernate.SessionFactory;
import org.hibernate.boot.MetadataSources;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.service.ServiceRegistry;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HibernateResource
implements TestRule {
    private static Logger logger = LoggerFactory.getLogger(HibernateResource.class);
    private final Configuration systemConfiguration = new SystemConfiguration();
    private ServiceRegistry registry;
    private SessionFactory sessionFactory;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                HibernateResource.this.initializeSearchIndexProvider();
                HibernateResource.this.createHibernateConnection();
                try {
                    base.evaluate();
                }
                finally {
                    HibernateResource.this.closeHibernateConnection();
                    HibernateResource.this.resetSearchIndexProvider();
                }
            }
        };
    }

    private void initializeSearchIndexProvider() {
        System.setProperty("hibernate.search.default.exclusive_index_use", "false");
    }

    private void resetSearchIndexProvider() {
        System.clearProperty("hibernate.search.default.exclusive_index_use");
    }

    private void closeHibernateConnection() throws IOException {
        if (!this.sessionFactory.isClosed()) {
            logger.debug("Closing SessionFactory");
            this.sessionFactory.close();
        }
        this.sessionFactory = null;
        logger.debug("Disposing ServiceRegistry");
        new HibernateServiceRegistryFactory(this.systemConfiguration).dispose(this.registry);
    }

    private void createHibernateConnection() throws IOException {
        logger.debug("Creating ServiceRegistry");
        this.registry = new HibernateServiceRegistryFactory(this.systemConfiguration).get();
        logger.debug("Creating SessionFactory");
        this.sessionFactory = new MetadataSources(this.registry).buildMetadata().buildSessionFactory();
        logger.debug("Injecting event listeners");
        EventListenerRegistry eventRegistry = (EventListenerRegistry)((SessionFactoryImpl)this.sessionFactory).getServiceRegistry().getService(EventListenerRegistry.class);
        eventRegistry.appendListeners(EventType.PRE_INSERT, (Object[])new PreInsertEventListener[]{new CreatedUpdatedListener()});
        eventRegistry.appendListeners(EventType.PRE_UPDATE, (Object[])new PreUpdateEventListener[]{new CreatedUpdatedListener()});
    }
}

