/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.rule;

import net.krotscheck.kangaroo.test.rule.HibernateResource;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class HibernateTestResource
implements TestRule {
    private final HibernateResource factoryProvider;
    private Session session;
    private SearchFactory searchFactory;
    private FullTextSession fullTextSession;

    public HibernateTestResource(HibernateResource factoryProvider) {
        this.factoryProvider = factoryProvider;
    }

    public Session getSession() {
        return this.session;
    }

    public SearchFactory getSearchFactory() {
        return this.searchFactory;
    }

    public FullTextSession getFullTextSession() {
        return this.fullTextSession;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                HibernateTestResource.this.createHibernateConnection();
                HibernateTestResource.this.startTransaction();
                try {
                    base.evaluate();
                }
                finally {
                    HibernateTestResource.this.closeTransaction();
                    HibernateTestResource.this.closeHibernateConnection();
                }
            }
        };
    }

    private void startTransaction() {
        this.getSession().getTransaction();
    }

    private void closeTransaction() {
        Transaction t = this.getSession().getTransaction();
        try {
            if (t.getStatus().equals((Object)TransactionStatus.ACTIVE)) {
                t.commit();
            }
        }
        catch (HibernateException he) {
            t.rollback();
            throw he;
        }
    }

    private void closeHibernateConnection() {
        this.searchFactory = null;
        if (this.fullTextSession.isOpen()) {
            this.fullTextSession.close();
        }
        this.fullTextSession = null;
        if (this.session.isOpen()) {
            this.session.close();
        }
        this.session = null;
    }

    private void createHibernateConnection() {
        this.session = this.factoryProvider.getSessionFactory().openSession();
        this.fullTextSession = Search.getFullTextSession((Session)this.session);
        this.searchFactory = this.fullTextSession.getSearchFactory();
    }
}

