/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.rule;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;

public final class SeleniumRule
implements TestRule {
    private ChromeDriver driver;

    public ChromeDriver getDriver() {
        return this.driver;
    }

    public void screenshot() {
        File scrFile = (File)this.driver.getScreenshotAs(OutputType.FILE);
        try {
            FileUtils.copyFile((File)scrFile, (File)new File("target/screenshots/" + scrFile.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    ChromeOptions chromeOptions = new ChromeOptions();
                    chromeOptions.setHeadless(true);
                    chromeOptions.addArguments(new String[]{"--disable-notifications"});
                    chromeOptions.addArguments(new String[]{"--window-size=1920,1080"});
                    SeleniumRule.this.driver = new ChromeDriver(chromeOptions);
                    base.evaluate();
                }
                finally {
                    if (SeleniumRule.this.driver != null) {
                        SeleniumRule.this.driver.close();
                    }
                }
            }
        };
    }

    public void dumpHTML() {
        String pageSource = this.driver.getPageSource();
        System.out.print(pageSource);
    }
}

