/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.rule;

import net.krotscheck.kangaroo.test.rule.HibernateResource;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class TestDataResource
implements TestRule {
    private final HibernateResource factoryProvider;

    public TestDataResource(HibernateResource factoryProvider) {
        this.factoryProvider = factoryProvider;
    }

    public final Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                SessionFactory factory = TestDataResource.this.factoryProvider.getSessionFactory();
                try (Session s = factory.openSession();){
                    TestDataResource.this.loadTestData(s);
                    try {
                        base.evaluate();
                    }
                    finally {
                        TestDataResource.this.clearTestData(s);
                    }
                }
            }
        };
    }

    protected abstract void loadTestData(Session var1);

    protected final SessionFactory getSessionFactory() {
        return this.factoryProvider.getSessionFactory();
    }

    private void clearTestData(Session session) {
        Query removeOwners = session.createQuery("UPDATE Application SET owner = null");
        Query removeApplications = session.createQuery("DELETE FROM Application");
        Query removeConfiguration = session.createQuery("DELETE FROM ConfigurationEntry");
        session.getTransaction().begin();
        removeOwners.executeUpdate();
        removeApplications.executeUpdate();
        removeConfiguration.executeUpdate();
        session.getTransaction().commit();
    }
}

