/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.rule;

import com.google.common.io.Files;
import java.io.File;
import net.krotscheck.kangaroo.server.Config;
import org.apache.commons.io.FileUtils;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class WorkingDirectoryRule
implements TestRule {
    private File workingDir;

    public File getWorkingDir() {
        return this.workingDir;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                WorkingDirectoryRule.this.workingDir = Files.createTempDir();
                System.setProperty((String)Config.WORKING_DIR.getKey(), WorkingDirectoryRule.this.workingDir.getAbsolutePath());
                try {
                    base.evaluate();
                }
                finally {
                    System.clearProperty((String)Config.WORKING_DIR.getKey());
                    FileUtils.deleteDirectory((File)WorkingDirectoryRule.this.workingDir);
                }
            }
        };
    }
}

