/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.rule.database;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.krotscheck.kangaroo.test.rule.database.AbstractTestDatabase;
import net.krotscheck.kangaroo.test.rule.database.ITestDatabase;
import org.h2.tools.DeleteDbFiles;

public final class H2TestDatabase
extends AbstractTestDatabase
implements ITestDatabase {
    private Connection connection;

    @Override
    public ITestDatabase create() {
        this.deleteDatabase(this.getJdbcConnectionString());
        this.connection = this.getConnection();
        return this;
    }

    @Override
    public String getName() {
        String url = this.getJdbcConnectionString();
        return url.substring(url.lastIndexOf(58));
    }

    @Override
    public Connection getConnection() {
        this.loadDriver();
        try {
            return DriverManager.getConnection(this.getJdbcConnectionString(), this.getUser(), this.getPassword());
        }
        catch (SQLException e) {
            throw new RuntimeException("cannot create h2 database", e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.connection.close();
            this.deleteDatabase(this.getJdbcConnectionString());
        }
        catch (SQLException sql) {
            throw new IOException(sql);
        }
    }

    private void deleteDatabase(String jbdcUrl) {
        String url = jbdcUrl.substring("jdbc:h2:".length());
        String[] parts = url.split(":");
        String protocol = parts[0];
        String path = parts[1];
        String dir = path.substring(0, path.lastIndexOf(47));
        String db = path.substring(path.lastIndexOf(47) + 1);
        if ("file".equals(protocol)) {
            DeleteDbFiles.execute((String)dir, (String)db, (boolean)true);
        }
    }
}

