/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.rule.database;

import java.io.IOException;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ws.rs.core.UriBuilder;
import net.krotscheck.kangaroo.test.TestConfig;
import net.krotscheck.kangaroo.test.rule.database.AbstractTestDatabase;
import net.krotscheck.kangaroo.test.rule.database.ITestDatabase;

public final class MariaDBTestDatabase
extends AbstractTestDatabase
implements ITestDatabase {
    @Override
    public String getName() {
        String url = this.getJdbcConnectionString();
        url = url.substring("jdbc:".length());
        URI path = UriBuilder.fromUri((String)url).replaceQuery("").build(new Object[0]);
        return path.getPath().substring("/".length());
    }

    @Override
    public void close() throws IOException {
        try (Connection connection = this.createRootConnection();){
            String query = String.format("DROP DATABASE %s;", this.getName());
            String permQuery = String.format("REVOKE ALL ON %s.* FROM %s@localhost;", this.getName(), this.getUser());
            try (Statement stmt = connection.createStatement();){
                stmt.addBatch(query);
                stmt.addBatch(permQuery);
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("cannot delete maria database", e);
        }
    }

    @Override
    public ITestDatabase create() {
        try (Connection connection = this.createRootConnection();){
            String query = String.format("CREATE DATABASE IF NOT EXISTS %s;", this.getName());
            String permQuery = String.format("GRANT ALL ON %s.* TO %s@localhost IDENTIFIED BY '%s';", this.getName(), this.getUser(), this.getPassword());
            try (Statement stmt = connection.createStatement();){
                stmt.addBatch(query);
                stmt.addBatch(permQuery);
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("cannot create maria database", e);
        }
        return this;
    }

    @Override
    public Connection getConnection() {
        this.loadDriver();
        try {
            return DriverManager.getConnection(this.getJdbcConnectionString(), this.getUser(), this.getPassword());
        }
        catch (SQLException e) {
            throw new RuntimeException("cannot connect to maria database", e);
        }
    }

    private Connection createRootConnection() {
        this.loadDriver();
        try {
            String rootUser = TestConfig.getMariaDBRootUser();
            String rootPassword = TestConfig.getMariaDBRootPassword();
            String dbUrl = this.getJdbcConnectionString();
            dbUrl = dbUrl.substring("jdbc:".length());
            URI dbpath = UriBuilder.fromPath((String)dbUrl).path("").build(new Object[0]);
            String rootJdbc = String.format("jdbc:%s://%s:%s/", dbpath.getScheme(), dbpath.getHost(), dbpath.getPort());
            return DriverManager.getConnection(rootJdbc, rootUser, rootPassword);
        }
        catch (SQLException e) {
            throw new RuntimeException("cannot connect to maria database", e);
        }
    }
}

