/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.rule.database;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.MariaDB53Dialect;
import org.hibernate.dialect.MariaDBDialect;

public enum TestDB {
    MARIADB(MariaDBDialect.class, MariaDB53Dialect.class),
    H2(H2Dialect.class);

    private final Set<Class<? extends Dialect>> dialects = new HashSet<Class<? extends Dialect>>();

    private TestDB(Class<? extends Dialect> ... setDialects) {
        this.dialects.addAll(Arrays.asList(setDialects));
    }

    public static TestDB fromDialect(String dbDialect) {
        try {
            return TestDB.fromDialect(Class.forName(dbDialect));
        }
        catch (ClassNotFoundException cnfe) {
            return H2;
        }
    }

    public static TestDB fromDialect(Class dialect) {
        for (TestDB value : TestDB.values()) {
            if (!value.dialects.contains(dialect)) continue;
            return value;
        }
        return H2;
    }
}

