/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.runner;

import java.util.List;
import net.krotscheck.kangaroo.test.runner.TestInstanceManager;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.parameterized.ParametersRunnerFactory;
import org.junit.runners.parameterized.TestWithParameters;

public final class ParameterizedSingleInstanceTestRunner
extends BlockJUnit4ClassRunner {
    private final Object[] parameters;
    private final String name;

    public ParameterizedSingleInstanceTestRunner(TestWithParameters test) throws InitializationError {
        super(test.getTestClass().getJavaClass());
        this.parameters = test.getParameters().toArray(new Object[test.getParameters().size()]);
        this.name = test.getName();
    }

    public Object createTest() throws Exception {
        return TestInstanceManager.getInstance(this.getTestClass(), this.getChildren().size(), this.parameters);
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
    }

    protected String getName() {
        return this.name;
    }

    protected String testName(FrameworkMethod method) {
        return method.getName() + this.getName();
    }

    protected Statement classBlock(RunNotifier notifier) {
        return this.childrenInvoker(notifier);
    }

    public static final class ParameterizedSingleInstanceTestRunnerFactory
    implements ParametersRunnerFactory {
        public Runner createRunnerForTestWithParameters(TestWithParameters test) throws InitializationError {
            return new ParameterizedSingleInstanceTestRunner(test);
        }
    }
}

