/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.test.runner;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.junit.runners.model.TestClass;

public final class TestInstanceManager {
    private static Map<String, ManagedInstance> instanceCache = new HashMap<String, ManagedInstance>();

    public static Object getInstance(TestClass tClass, int totalCount) throws Exception {
        return TestInstanceManager.getInstance(tClass, totalCount, null);
    }

    public static Object getInstance(TestClass tClass, int totalCount, Object ... initArgs) throws Exception {
        String key;
        String hashCode = "";
        if (initArgs != null) {
            hashCode = "_" + String.valueOf(Arrays.hashCode(initArgs));
        }
        if (!instanceCache.containsKey(key = String.format("%s%s", tClass.getName(), hashCode))) {
            instanceCache.put(key, new ManagedInstance(totalCount, tClass.getOnlyConstructor().newInstance(initArgs)));
        }
        ManagedInstance marker = instanceCache.get(key);
        Object instance = marker.get();
        if (marker.isExhausted()) {
            instanceCache.remove(key);
        }
        return instance;
    }

    private TestInstanceManager() {
    }

    private static class ManagedInstance {
        private final int totalCount;
        private int currentCount = 0;
        private final Object instance;

        ManagedInstance(int totalCount, Object instance) {
            this.totalCount = totalCount;
            this.instance = instance;
        }

        public Object get() {
            ++this.currentCount;
            return this.instance;
        }

        public boolean isExhausted() {
            return this.currentCount >= this.totalCount;
        }
    }
}

