/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.util.HttpUtil;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.utils.URIBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class HttpUtilTest {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    @Test
    public void testPrivateConstructor() throws Exception {
        Constructor c = HttpUtil.class.getDeclaredConstructor(new Class[0]);
        Assert.assertTrue((boolean)Modifier.isPrivate(c.getModifiers()));
        c.setAccessible(true);
        c.newInstance(new Object[0]);
    }

    @Test
    public void authHeaderBasic() {
        Assert.assertEquals((Object)"Basic bG9naW46cGFzc3dvcmQ=", (Object)HttpUtil.authHeaderBasic((String)"login", (String)"password"));
        Assert.assertEquals((Object)"", (Object)HttpUtil.authHeaderBasic((String)null, (String)"password"));
        Assert.assertEquals((Object)"", (Object)HttpUtil.authHeaderBasic((String)"login", null));
        Assert.assertEquals((Object)"Basic MDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMGE6cGFzc3dvcmQ=", (Object)HttpUtil.authHeaderBasic((BigInteger)BigInteger.TEN, (String)"password"));
    }

    @Test
    public void authHeaderBearer() {
        Assert.assertEquals((Object)"Bearer test_token", (Object)HttpUtil.authHeaderBearer((String)"test_token"));
        Assert.assertEquals((Object)"Bearer 0000000000000000000000000000000a", (Object)HttpUtil.authHeaderBearer((BigInteger)BigInteger.TEN));
        Assert.assertEquals((Object)"", (Object)HttpUtil.authHeaderBearer((String)null));
    }

    @Test
    public void parseQueryParamsFromUri() throws Exception {
        URI singleParams = new URIBuilder("http://example.com/?foo=bar&lol=cat").build();
        MultivaluedMap params = HttpUtil.parseQueryParams((URI)singleParams);
        Assert.assertEquals((long)2L, (long)params.size());
        Assert.assertEquals((Object)"cat", (Object)params.getFirst((Object)"lol"));
        Assert.assertEquals((Object)"bar", (Object)params.getFirst((Object)"foo"));
        MultivaluedMap params2 = HttpUtil.parseQueryParams((URI)null);
        Assert.assertEquals((long)0L, (long)params2.size());
    }

    @Test
    public void parseQueryParamsFromBody() {
        Response r = (Response)Mockito.mock(Response.class);
        InputStream stream1 = IOUtils.toInputStream((String)"foo=bar&lol=cat", (Charset)UTF8);
        ((Response)Mockito.doReturn((Object)stream1).when((Object)r)).getEntity();
        MultivaluedMap params = HttpUtil.parseBodyParams((Response)r);
        Assert.assertEquals((long)2L, (long)params.size());
        Assert.assertEquals((Object)"cat", (Object)params.getFirst((Object)"lol"));
        Assert.assertEquals((Object)"bar", (Object)params.getFirst((Object)"foo"));
        InputStream stream2 = IOUtils.toInputStream((String)"", (Charset)UTF8);
        ((Response)Mockito.doReturn((Object)stream2).when((Object)r)).getEntity();
        MultivaluedMap params2 = HttpUtil.parseBodyParams((Response)r);
        Assert.assertEquals((long)0L, (long)params2.size());
        InputStream stream3 = IOUtils.toInputStream((String)"", (Charset)UTF8);
        ((Response)Mockito.doThrow(IOException.class).when((Object)r)).getEntity();
        MultivaluedMap params3 = HttpUtil.parseBodyParams((Response)r);
        Assert.assertEquals((long)0L, (long)params3.size());
    }

    @Test
    public void parseBodyParamsFromRawString() {
        MultivaluedMap params = HttpUtil.parseQueryParams((String)"foo=bar&lol=cat");
        Assert.assertEquals((long)2L, (long)params.size());
        Assert.assertEquals((Object)"cat", (Object)params.getFirst((Object)"lol"));
        Assert.assertEquals((Object)"bar", (Object)params.getFirst((Object)"foo"));
        MultivaluedMap params2 = HttpUtil.parseQueryParams((String)"");
        Assert.assertEquals((long)0L, (long)params2.size());
        MultivaluedMap params3 = HttpUtil.parseQueryParams((String)null);
        Assert.assertEquals((long)0L, (long)params3.size());
        MultivaluedMap params4 = HttpUtil.parseQueryParams((String)"noValue");
        Assert.assertEquals((long)1L, (long)params4.size());
        Assert.assertNull((Object)params.getFirst((Object)"noValue"));
        MultivaluedMap params5 = HttpUtil.parseQueryParams((String)"foo=bar&foo=baz");
        Assert.assertEquals((long)1L, (long)params5.size());
        Assert.assertEquals((long)2L, (long)((List)params5.get((Object)"foo")).size());
        Assert.assertTrue((boolean)((List)params5.get((Object)"foo")).contains("bar"));
        Assert.assertTrue((boolean)((List)params5.get((Object)"foo")).contains("baz"));
    }
}

