/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import net.krotscheck.kangaroo.util.InvalidFieldException;
import net.krotscheck.kangaroo.util.ParamUtil;
import org.junit.Assert;
import org.junit.Test;

public final class ParamUtilTest {
    @Test
    public void testPrivateConstructor() throws Exception {
        Constructor c = ParamUtil.class.getDeclaredConstructor(new Class[0]);
        Assert.assertTrue((boolean)Modifier.isPrivate(c.getModifiers()));
        c.setAccessible(true);
        c.newInstance(new Object[0]);
    }

    @Test
    public void testGetOne() {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.add((Object)"foo", (Object)"bar");
        String result = ParamUtil.getOne((MultivaluedMap)params, (String)"foo");
        Assert.assertEquals((Object)"bar", (Object)result);
    }

    @Test(expected=InvalidFieldException.class)
    public void testGetOneNoValue() {
        MultivaluedHashMap params = new MultivaluedHashMap();
        ParamUtil.getOne((MultivaluedMap)params, (String)"does_not_exist");
    }

    @Test(expected=InvalidFieldException.class)
    public void testGetOneMultiResult() {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.add((Object)"foo", (Object)"one");
        params.add((Object)"foo", (Object)"two");
        ParamUtil.getOne((MultivaluedMap)params, (String)"foo");
    }
}

