/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import net.krotscheck.kangaroo.util.InvalidHostException;
import net.krotscheck.kangaroo.util.RequestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class RequestUtilTest {
    public ContainerRequestContext buildContext(String requestUri, MultivaluedMap<String, String> headers) throws Exception {
        ContainerRequestContext mockContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        UriInfo mockInfo = (UriInfo)Mockito.mock(UriInfo.class);
        URI uri = new URI(requestUri);
        ((UriInfo)Mockito.doReturn((Object)uri).when((Object)mockInfo)).getRequestUri();
        ((ContainerRequestContext)Mockito.doReturn(headers).when((Object)mockContext)).getHeaders();
        ((ContainerRequestContext)Mockito.doReturn((Object)mockInfo).when((Object)mockContext)).getUriInfo();
        return mockContext;
    }

    @Test
    public void testPrivateConstructor() throws Exception {
        Constructor c = RequestUtil.class.getDeclaredConstructor(new Class[0]);
        Assert.assertTrue((boolean)Modifier.isPrivate(c.getModifiers()));
        c.setAccessible(true);
        c.newInstance(new Object[0]);
    }

    @Test
    public void testCorsRequestedMethod() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Access-Control-Request-Method", (Object)"OPTIONS");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        String method = RequestUtil.getCORSRequestedMethod((ContainerRequestContext)mockContext);
        Assert.assertEquals((Object)"OPTIONS", (Object)method);
    }

    @Test
    public void testCorsRequestedMethodEmpty() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        String method = RequestUtil.getCORSRequestedMethod((ContainerRequestContext)mockContext);
        Assert.assertNull((Object)method);
    }

    @Test
    public void testCorsRequestedHeaders() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Access-Control-Request-Headers", (Object)"One, TWO , Three, Four,,Five");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        List reqHeaders = RequestUtil.getCORSRequestedHeaders((ContainerRequestContext)mockContext);
        Assert.assertEquals((long)5L, (long)reqHeaders.size());
        Assert.assertTrue((boolean)reqHeaders.contains("one"));
        Assert.assertTrue((boolean)reqHeaders.contains("two"));
        Assert.assertTrue((boolean)reqHeaders.contains("three"));
        Assert.assertTrue((boolean)reqHeaders.contains("four"));
        Assert.assertTrue((boolean)reqHeaders.contains("five"));
    }

    @Test
    public void testCorsRequestedEmptyHeaders() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        List reqHeaders = RequestUtil.getCORSRequestedHeaders((ContainerRequestContext)mockContext);
        Assert.assertEquals((long)0L, (long)reqHeaders.size());
    }

    @Test
    public void testGetHost() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Host", (Object)"host.example.com");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        URI result = RequestUtil.getHost((ContainerRequestContext)mockContext);
        Assert.assertEquals((Object)"https://host.example.com", (Object)result.toString());
    }

    @Test
    public void testGetHostPort() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Host", (Object)"host.example.com:8080");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com:8080", (MultivaluedMap<String, String>)headers);
        URI result = RequestUtil.getHost((ContainerRequestContext)mockContext);
        Assert.assertEquals((Object)"https://host.example.com:8080", (Object)result.toString());
    }

    @Test(expected=InvalidHostException.class)
    public void testGetHostInvalid() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Host", (Object)"host.example.com:string");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        RequestUtil.getHost((ContainerRequestContext)mockContext);
    }

    @Test(expected=InvalidHostException.class)
    public void testGetHostEmpty() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Host", (Object)"");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        RequestUtil.getHost((ContainerRequestContext)mockContext);
    }

    @Test
    public void testForwardedHost() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"X-Forwarded-Proto", (Object)"https");
        headers.add((Object)"X-Forwarded-Port", (Object)"8080");
        headers.add((Object)"X-Forwarded-Host", (Object)"example.com");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        URI result = RequestUtil.getForwardedHost((ContainerRequestContext)mockContext);
        Assert.assertEquals((Object)"https://example.com:8080", (Object)result.toString());
    }

    @Test
    public void testForwardedHostNoPort() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"X-Forwarded-Proto", (Object)"https");
        headers.add((Object)"X-Forwarded-Host", (Object)"example.com");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        URI result = RequestUtil.getForwardedHost((ContainerRequestContext)mockContext);
        Assert.assertEquals((Object)"https://example.com", (Object)result.toString());
    }

    @Test
    public void testForwardedHostNoHost() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"X-Forwarded-Proto", (Object)"https");
        headers.add((Object)"X-Forwarded-Port", (Object)"8080");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        URI result = RequestUtil.getForwardedHost((ContainerRequestContext)mockContext);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testForwardedHostInvalidHost() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"X-Forwarded-Proto", (Object)"https");
        headers.add((Object)"X-Forwarded-Port", (Object)"8080");
        headers.add((Object)"X-Forwarded-Host", (Object)"     ");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        URI result = RequestUtil.getForwardedHost((ContainerRequestContext)mockContext);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testForwardedHostInvalidPort() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"X-Forwarded-Proto", (Object)"https");
        headers.add((Object)"X-Forwarded-Port", (Object)"string");
        headers.add((Object)"X-Forwarded-Host", (Object)"example.com");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        URI result = RequestUtil.getForwardedHost((ContainerRequestContext)mockContext);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testForwardedHostNoProtocol() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"X-Forwarded-Port", (Object)"string");
        headers.add((Object)"X-Forwarded-Host", (Object)"example.com");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        URI result = RequestUtil.getForwardedHost((ContainerRequestContext)mockContext);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testForwardedHostInvalidProtocol() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"X-Forwarded-Proto", (Object)"&&$$");
        headers.add((Object)"X-Forwarded-Port", (Object)"string");
        headers.add((Object)"X-Forwarded-Host", (Object)"example.com");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        URI result = RequestUtil.getForwardedHost((ContainerRequestContext)mockContext);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testCrossOriginWithHost() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Host", (Object)"host.example.com");
        ContainerRequestContext mockContext = this.buildContext("http://host.example.com", (MultivaluedMap<String, String>)headers);
        Boolean result = RequestUtil.isCrossOriginRequest((ContainerRequestContext)mockContext);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testCrossOriginWithOriginAndHost() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Origin", (Object)"http://host.example.com");
        headers.add((Object)"Host", (Object)"host.example.com");
        ContainerRequestContext mockContext = this.buildContext("http://host.example.com", (MultivaluedMap<String, String>)headers);
        Boolean result = RequestUtil.isCrossOriginRequest((ContainerRequestContext)mockContext);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testCrossOriginWithOriginAndHostMismatch() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Origin", (Object)"http://example.com");
        headers.add((Object)"Host", (Object)"host.example.com");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        Boolean result = RequestUtil.isCrossOriginRequest((ContainerRequestContext)mockContext);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testCrossOriginWithOriginAndForward() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Origin", (Object)"http://example.com:8080");
        headers.add((Object)"X-Forwarded-Proto", (Object)"http");
        headers.add((Object)"X-Forwarded-Port", (Object)"8080");
        headers.add((Object)"X-Forwarded-Host", (Object)"example.com");
        headers.add((Object)"Host", (Object)"host.example.com");
        ContainerRequestContext mockContext = this.buildContext("http://host.example.com", (MultivaluedMap<String, String>)headers);
        Boolean result = RequestUtil.isCrossOriginRequest((ContainerRequestContext)mockContext);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testCrossOriginWithOriginAndForwardMismatch() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Origin", (Object)"http://host.example.com:8080");
        headers.add((Object)"X-Forwarded-Proto", (Object)"http");
        headers.add((Object)"X-Forwarded-Port", (Object)"8081");
        headers.add((Object)"X-Forwarded-Host", (Object)"example.com");
        headers.add((Object)"Host", (Object)"host.example.com");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com:8080", (MultivaluedMap<String, String>)headers);
        Boolean result = RequestUtil.isCrossOriginRequest((ContainerRequestContext)mockContext);
        Assert.assertTrue((boolean)result);
    }

    @Test(expected=InvalidHostException.class)
    public void testCrossOriginWithOriginAndInvalidForward() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Origin", (Object)"http://example.com:8080");
        headers.add((Object)"X-Forwarded-Proto", (Object)"http");
        headers.add((Object)"X-Forwarded-Port", (Object)"string");
        headers.add((Object)"X-Forwarded-Host", (Object)"example.com");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        RequestUtil.isCrossOriginRequest((ContainerRequestContext)mockContext);
    }

    @Test
    public void testCrossOriginWithReferrerAndHost() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Referer", (Object)"http://host.example.com/some/page.html");
        headers.add((Object)"Host", (Object)"host.example.com");
        ContainerRequestContext mockContext = this.buildContext("http://host.example.com", (MultivaluedMap<String, String>)headers);
        Boolean result = RequestUtil.isCrossOriginRequest((ContainerRequestContext)mockContext);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testCrossOriginWithReferrerAndHostMismatch() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Referer", (Object)"http://example.com/some/page.html");
        headers.add((Object)"Host", (Object)"another.example.com");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        Boolean result = RequestUtil.isCrossOriginRequest((ContainerRequestContext)mockContext);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testCrossOriginWithReferrerAndForward() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Host", (Object)"proxied.example.com");
        headers.add((Object)"Referer", (Object)"http://example.com:8080/some/page.html");
        headers.add((Object)"X-Forwarded-Proto", (Object)"http");
        headers.add((Object)"X-Forwarded-Port", (Object)"8080");
        headers.add((Object)"X-Forwarded-Host", (Object)"example.com");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        Boolean result = RequestUtil.isCrossOriginRequest((ContainerRequestContext)mockContext);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testCrossOriginWithReferrerAndForwardMisMatch() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Host", (Object)"proxy.example.com");
        headers.add((Object)"Referer", (Object)"http://example.com/some/page.html");
        headers.add((Object)"X-Forwarded-Proto", (Object)"http");
        headers.add((Object)"X-Forwarded-Host", (Object)"another.example.com");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        Boolean result = RequestUtil.isCrossOriginRequest((ContainerRequestContext)mockContext);
        Assert.assertTrue((boolean)result);
    }

    @Test(expected=InvalidHostException.class)
    public void testCrossOriginWithReferrerAndInvalidForward() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Referer", (Object)"http://example.com/some/page.html");
        headers.add((Object)"X-Forwarded-Proto", (Object)"http");
        headers.add((Object)"X-Forwarded-Port", (Object)"string");
        headers.add((Object)"X-Forwarded-Host", (Object)"example.com");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        RequestUtil.isCrossOriginRequest((ContainerRequestContext)mockContext);
    }

    @Test(expected=InvalidHostException.class)
    public void testCrossOriginNoOriginOrReferrer() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"X-Forwarded-Proto", (Object)"http");
        headers.add((Object)"X-Forwarded-Port", (Object)"string");
        headers.add((Object)"X-Forwarded-Host", (Object)"example.com");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        RequestUtil.isCrossOriginRequest((ContainerRequestContext)mockContext);
    }

    @Test(expected=InvalidHostException.class)
    public void testCrossOriginNoHostOrForward() throws Exception {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Origin", (Object)"http://example.com:8080");
        ContainerRequestContext mockContext = this.buildContext("https://host.example.com", (MultivaluedMap<String, String>)headers);
        RequestUtil.isCrossOriginRequest((ContainerRequestContext)mockContext);
    }
}

