/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.cors;

import com.google.common.base.Strings;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.cors.ICORSValidator;
import net.krotscheck.kangaroo.util.RequestUtil;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;

@PreMatching
@Priority(value=900)
public final class CORSFilter
implements ContainerResponseFilter {
    private final List<String> allowedHeaders;
    private final List<String> allowedMethods;
    private final List<String> exposedHeaders;
    private final ICORSValidator validator;

    @Inject
    public CORSFilter(@Named(value="CORS_ALLOWED_HEADERS") Iterable<String> allowedHeaders, @Named(value="CORS_ALLOWED_METHODS") Iterable<String> allowedMethods, @Named(value="CORS_EXPOSED_HEADERS") Iterable<String> exposedHeaders, ICORSValidator validator) {
        this.allowedHeaders = Streams.stream(allowedHeaders).filter(h -> !Strings.isNullOrEmpty((String)h)).map(String::toLowerCase).collect(Collectors.toList());
        this.allowedMethods = Streams.stream(allowedMethods).filter(h -> !Strings.isNullOrEmpty((String)h)).collect(Collectors.toList());
        this.exposedHeaders = Streams.stream(exposedHeaders).filter(h -> !Strings.isNullOrEmpty((String)h)).map(String::toLowerCase).collect(Collectors.toList());
        this.validator = validator;
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        response.getHeaders().addAll((Object)"Vary", new Object[]{"Origin"});
        URI origin = RequestUtil.getOrigin(request);
        if (origin == null || !this.validator.isValidCORSOrigin(origin)) {
            return;
        }
        if ("OPTIONS".equals(request.getMethod())) {
            this.preflightFilter(origin, request, response);
        } else if (this.allowedMethods.contains(request.getMethod())) {
            this.requestFilter(origin, response);
        }
    }

    private void preflightFilter(URI origin, ContainerRequestContext request, ContainerResponseContext response) {
        MultivaluedMap resHeaders = response.getHeaders();
        if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            response.setStatus(Response.Status.OK.getStatusCode());
        }
        resHeaders.add((Object)"Vary", (Object)"Access-Control-Request-Headers");
        resHeaders.add((Object)"Vary", (Object)"Access-Control-Request-Method");
        String method = RequestUtil.getCORSRequestedMethod(request);
        if (!this.allowedMethods.contains(method)) {
            return;
        }
        resHeaders.add((Object)"Access-Control-Allow-Methods", (Object)method);
        resHeaders.add((Object)"Access-Control-Allow-Origin", (Object)origin);
        resHeaders.add((Object)"Access-Control-Allow-Credentials", (Object)"true");
        resHeaders.add((Object)"Access-Control-Max-Age", (Object)300);
        List<String> requestedHeaders = RequestUtil.getCORSRequestedHeaders(request);
        this.allowedHeaders.stream().filter(requestedHeaders::contains).forEach(h -> resHeaders.add((Object)"Access-Control-Allow-Headers", h));
    }

    private void requestFilter(URI origin, ContainerResponseContext response) {
        MultivaluedMap headers = response.getHeaders();
        headers.add((Object)"Origin", (Object)origin);
        List declaredExposedHeaders = headers.keySet().stream().map(String::toLowerCase).filter(this.exposedHeaders::contains).collect(Collectors.toList());
        headers.addAll((Object)"Access-Control-Expose-Headers", declaredExposedHeaders);
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)this.bind(CORSFilter.class).to(ContainerResponseFilter.class)).in(Singleton.class);
        }
    }
}

