/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.factory;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.DisposableSupplier;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.hibernate.SessionFactory;
import org.hibernate.boot.MetadataSources;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCommitDeleteEventListener;
import org.hibernate.event.spi.PostCommitInsertEventListener;
import org.hibernate.event.spi.PostCommitUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HibernateSessionFactoryFactory
implements DisposableSupplier<SessionFactory> {
    private static Logger logger = LoggerFactory.getLogger(HibernateSessionFactoryFactory.class);
    private ServiceRegistry serviceRegistry;
    private InjectionManager injectionManager;

    @Inject
    public HibernateSessionFactoryFactory(ServiceRegistry registry, InjectionManager iManager) {
        this.serviceRegistry = registry;
        this.injectionManager = iManager;
    }

    public SessionFactory get() {
        logger.trace("Creating hibernate session factory.");
        SessionFactory factory = new MetadataSources(this.serviceRegistry).buildMetadata().buildSessionFactory();
        this.injectEventListeners((ServiceRegistry)((SessionFactoryImpl)factory).getServiceRegistry());
        return factory;
    }

    public void dispose(SessionFactory sessionFactory) {
        if (sessionFactory != null && !sessionFactory.isClosed()) {
            logger.debug("Disposing of hibernate session factory.");
            sessionFactory.close();
        }
    }

    private void injectEventListeners(ServiceRegistry registry) {
        EventListenerRegistry eventRegistry = (EventListenerRegistry)registry.getService(EventListenerRegistry.class);
        List postInsertEvents = this.injectionManager.getAllInstances(PostInsertEventListener.class);
        for (Object piEventListener : postInsertEvents) {
            logger.trace("Registering PostInsert: " + piEventListener.getClass().getCanonicalName());
            eventRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{piEventListener});
        }
        List postUpdateEvents = this.injectionManager.getAllInstances(PostUpdateEventListener.class);
        for (Object puEventListener : postUpdateEvents) {
            logger.trace("Registering PostUpdate: " + puEventListener.getClass().getCanonicalName());
            eventRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{puEventListener});
        }
        List postDeleteEvents = this.injectionManager.getAllInstances(PostDeleteEventListener.class);
        for (Object pdEventListener : postDeleteEvents) {
            logger.trace("Registering PostDelete: " + pdEventListener.getClass().getCanonicalName());
            eventRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{pdEventListener});
        }
        List preInsertEvents = this.injectionManager.getAllInstances(PreInsertEventListener.class);
        for (Object piEventListener : preInsertEvents) {
            logger.trace("Registering PreInsert: " + piEventListener.getClass().getCanonicalName());
            eventRegistry.appendListeners(EventType.PRE_INSERT, (Object[])new PreInsertEventListener[]{piEventListener});
        }
        List preUpdateEvents = this.injectionManager.getAllInstances(PreUpdateEventListener.class);
        for (Object puEventListener : preUpdateEvents) {
            logger.trace("Registering PreUpdate: " + puEventListener.getClass().getCanonicalName());
            eventRegistry.appendListeners(EventType.PRE_UPDATE, (Object[])new PreUpdateEventListener[]{puEventListener});
        }
        List preDeleteEvents = this.injectionManager.getAllInstances(PreDeleteEventListener.class);
        for (Object pdEventListener : preDeleteEvents) {
            logger.trace("Registering PreDelete: " + pdEventListener.getClass().getCanonicalName());
            eventRegistry.appendListeners(EventType.PRE_DELETE, (Object[])new PreDeleteEventListener[]{pdEventListener});
        }
        List pciEvents = this.injectionManager.getAllInstances(PostCommitInsertEventListener.class);
        for (Object cpiEventListener : pciEvents) {
            logger.trace("Registering PostCommitInsert: " + cpiEventListener.getClass().getCanonicalName());
            eventRegistry.appendListeners(EventType.POST_COMMIT_INSERT, (Object[])new PostInsertEventListener[]{cpiEventListener});
        }
        List pcuEvents = this.injectionManager.getAllInstances(PostCommitUpdateEventListener.class);
        for (PostCommitUpdateEventListener cpuEventListener : pcuEvents) {
            logger.trace("Registering PostCommitUpdate: " + cpuEventListener.getClass().getCanonicalName());
            eventRegistry.appendListeners(EventType.POST_COMMIT_UPDATE, (Object[])new PostUpdateEventListener[]{cpuEventListener});
        }
        List pcdEvents = this.injectionManager.getAllInstances(PostCommitDeleteEventListener.class);
        for (PostCommitDeleteEventListener cpdEventListener : pcdEvents) {
            logger.trace("Registering PostCommitDelete: " + cpdEventListener.getClass().getCanonicalName());
            eventRegistry.appendListeners(EventType.POST_COMMIT_DELETE, (Object[])new PostDeleteEventListener[]{cpdEventListener});
        }
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((SupplierClassBinding)this.bindFactory(HibernateSessionFactoryFactory.class).to(SessionFactory.class)).in(Singleton.class);
        }
    }
}

