/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.factory;

import com.mchange.v2.c3p0.PooledDataSource;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.hibernate.SessionFactory;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.service.internal.SessionFactoryServiceRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PooledDataSourceFactory
implements Supplier<PooledDataSource> {
    private static Logger logger = LoggerFactory.getLogger(PooledDataSourceFactory.class);
    private final SessionFactoryImpl sessionFactory;

    @Inject
    public PooledDataSourceFactory(SessionFactory sessionFactory) {
        this.sessionFactory = (SessionFactoryImpl)sessionFactory.unwrap(SessionFactoryImpl.class);
    }

    @Override
    public PooledDataSource get() {
        logger.trace("Extracting PooledDataSource from hibernate session factory.");
        SessionFactoryServiceRegistryImpl src = (SessionFactoryServiceRegistryImpl)this.sessionFactory.getServiceRegistry();
        ConnectionProvider cp = (ConnectionProvider)src.getService(ConnectionProvider.class);
        return (PooledDataSource)cp.unwrap(PooledDataSource.class);
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((SupplierClassBinding)this.bindFactory(PooledDataSourceFactory.class).to(PooledDataSource.class)).in(Singleton.class);
        }
    }
}

