/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.id;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.inject.Singleton;
import javax.ws.rs.FormParam;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.id.MalformedIdException;
import org.glassfish.jersey.internal.inject.Custom;

@Provider
@Singleton
@Custom
public final class Base16BigIntegerConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> clazz, Type type, Annotation[] annotations) {
        if (!clazz.getName().equals(BigInteger.class.getName())) {
            return null;
        }
        for (Annotation a : Arrays.asList(annotations)) {
            if (a instanceof PathParam) {
                return new BigIntConverter(NotFoundException::new);
            }
            if (a instanceof QueryParam) {
                return new BigIntConverter(MalformedIdException::new);
            }
            if (!(a instanceof FormParam)) continue;
            return new BigIntConverter(MalformedIdException::new);
        }
        return null;
    }

    private static final class BigIntConverter<T>
    implements ParamConverter<T> {
        private final Supplier<? extends WebApplicationException> supplier;

        BigIntConverter(Supplier<? extends WebApplicationException> supplier) {
            this.supplier = supplier;
        }

        public T fromString(String value) {
            try {
                return (T)IdUtil.fromString(value);
            }
            catch (Exception e) {
                throw this.supplier.get();
            }
        }

        public String toString(T value) {
            return IdUtil.toString((BigInteger)value);
        }
    }
}

