/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.id;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.type.BigIntegerType;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.ObjectNameNormalizer;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.resource.jdbc.ResourceRegistry;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;
import org.hibernate.usertype.UserType;

public final class SecureRandomIdGenerator
implements IdentifierGenerator,
Configurable {
    private String sql;
    private Type type = new CustomType((UserType)new BigIntegerType());

    protected void setSql(String sql) {
        this.sql = sql;
    }

    public Serializable generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        BigInteger nextId;
        while (this.hasDuplicate(session, nextId = IdUtil.next())) {
        }
        return nextId;
    }

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        this.type = type;
        String column = params.getProperty("target_column");
        String table = params.getProperty("target_table");
        JdbcEnvironment jdbcEnvironment = (JdbcEnvironment)serviceRegistry.getService(JdbcEnvironment.class);
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        column = normalizer.normalizeIdentifierQuoting(column).render(jdbcEnvironment.getDialect());
        table = normalizer.toDatabaseIdentifierText(table);
        this.sql = String.format("select count(%s) from %s where %s=?", column, table, column);
    }

    protected boolean hasDuplicate(SharedSessionContractImplementor session, BigInteger id) {
        JdbcCoordinator coordinator = session.getJdbcCoordinator();
        LogicalConnectionImplementor logicalConnection = coordinator.getLogicalConnection();
        ResourceRegistry resourceRegistry = logicalConnection.getResourceRegistry();
        ResultSet resultSet = null;
        PreparedStatement st = coordinator.getStatementPreparer().prepareStatement(this.sql);
        try {
            this.type.nullSafeSet(st, (Object)id, 1, session);
            resultSet = coordinator.getResultSetReturn().extract(st);
            int count = 0;
            if (resultSet.next()) {
                count = resultSet.getInt(1);
            }
            resourceRegistry.release(resultSet, (Statement)st);
            boolean bl = count > 0;
            return bl;
        }
        catch (SQLException | GenericJDBCException sle) {
            throw new IdentifierGenerationException("Cannot scan for id", sle);
        }
        finally {
            resourceRegistry.release((Statement)st);
            coordinator.afterStatementExecution();
        }
    }
}

