/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.lifecycle;

import javax.inject.Inject;
import javax.inject.Singleton;
import net.krotscheck.kangaroo.common.hibernate.migration.DatabaseMigrationState;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.impl.ImplementationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchIndexContainerLifecycleListener
implements ContainerLifecycleListener {
    private static Logger logger = LoggerFactory.getLogger(SearchIndexContainerLifecycleListener.class);
    private final SessionFactory sessionFactory;
    private final DatabaseMigrationState migrationState;

    @Inject
    public SearchIndexContainerLifecycleListener(SessionFactory sessionFactory, DatabaseMigrationState migrationState) {
        this.sessionFactory = sessionFactory;
        this.migrationState = migrationState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStartup(Container container) {
        if (!this.migrationState.isSchemaChanged()) {
            logger.debug("Schema did not change, aborting rebuild...");
            return;
        }
        logger.debug("Rebuilding Search Index...");
        try (Session s = this.sessionFactory.openSession();){
            FullTextSession fullTextSession = this.getFulltextSession(s);
            fullTextSession.createIndexer(new Class[0]).startAndWait();
        }
    }

    public void onReload(Container container) {
    }

    public void onShutdown(Container container) {
    }

    public FullTextSession getFulltextSession(Session s) {
        return ImplementationFactory.createFullTextSession((Session)s);
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)this.bind(SearchIndexContainerLifecycleListener.class).to(ContainerLifecycleListener.class)).in(Singleton.class);
        }
    }
}

