/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.listener;

import java.util.Calendar;
import java.util.TimeZone;
import javax.inject.Singleton;
import net.krotscheck.kangaroo.common.hibernate.entity.ICreatedDateEntity;
import net.krotscheck.kangaroo.common.hibernate.entity.IModifiedDateEntity;
import org.apache.commons.lang3.ArrayUtils;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;

public final class CreatedUpdatedListener
implements PreInsertEventListener,
PreUpdateEventListener {
    private final TimeZone timeZone = TimeZone.getTimeZone("UTC");

    public boolean onPreInsert(PreInsertEvent event) {
        String[] propertyNames;
        Object entity = event.getEntity();
        Object[] state = event.getState();
        Calendar now = Calendar.getInstance(this.timeZone);
        if (entity instanceof ICreatedDateEntity) {
            propertyNames = event.getPersister().getEntityMetamodel().getPropertyNames();
            ICreatedDateEntity persistingEntity = (ICreatedDateEntity)entity;
            persistingEntity.setCreatedDate(now);
            this.setValue(state, propertyNames, "createdDate", persistingEntity.getCreatedDate());
        }
        if (entity instanceof IModifiedDateEntity) {
            propertyNames = event.getPersister().getEntityMetamodel().getPropertyNames();
            IModifiedDateEntity modifiedEntity = (IModifiedDateEntity)entity;
            modifiedEntity.setModifiedDate(now);
            this.setValue(state, propertyNames, "modifiedDate", modifiedEntity.getModifiedDate());
        }
        return false;
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        Object entity = event.getEntity();
        if (entity instanceof IModifiedDateEntity) {
            String[] propertyNames = event.getPersister().getEntityMetamodel().getPropertyNames();
            Object[] state = event.getState();
            Calendar now = Calendar.getInstance(this.timeZone);
            IModifiedDateEntity persistingEntity = (IModifiedDateEntity)entity;
            persistingEntity.setModifiedDate(now);
            this.setValue(state, propertyNames, "modifiedDate", persistingEntity.getModifiedDate());
        }
        return false;
    }

    private void setValue(Object[] currentState, String[] propertyNames, String propertyToSet, Object value) {
        int index = ArrayUtils.indexOf((Object[])propertyNames, (Object)propertyToSet);
        currentState[index] = value;
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)((ClassBinding)this.bind(CreatedUpdatedListener.class).to(PreInsertEventListener.class)).to(PreUpdateEventListener.class)).in(Singleton.class);
        }
    }
}

