/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.migration;

import com.mchange.v2.c3p0.PooledDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import net.krotscheck.kangaroo.common.hibernate.lifecycle.SearchIndexContainerLifecycleListener;
import net.krotscheck.kangaroo.common.hibernate.migration.DatabaseMigrationState;
import net.krotscheck.kangaroo.common.hibernate.migration.LiquibaseMigrationWatcher;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LiquibaseMigration
implements Supplier<DatabaseMigrationState> {
    private static Logger logger = LoggerFactory.getLogger(SearchIndexContainerLifecycleListener.class);
    private final PooledDataSource dataSource;
    private String migrationPath = "liquibase/db.changelog-master.yaml";

    @Inject
    public LiquibaseMigration(PooledDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getMigrationPath() {
        return this.migrationPath;
    }

    public void setMigrationPath(String migrationPath) {
        this.migrationPath = migrationPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseMigrationState get() {
        DatabaseMigrationState databaseMigrationState;
        Connection c = this.dataSource.getConnection();
        try {
            JdbcConnection connection = new JdbcConnection(c);
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            Liquibase liquibase = new Liquibase(this.getMigrationPath(), (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            List changesets = liquibase.getChangeSetStatuses(new Contexts(), new LabelExpression());
            LiquibaseMigrationWatcher w = new LiquibaseMigrationWatcher(changesets);
            liquibase.setChangeExecListener((ChangeExecListener)w);
            liquibase.update(new Contexts(), new LabelExpression());
            databaseMigrationState = new DatabaseMigrationState(w.isMigrated(), w.getCurrentVersion());
        }
        catch (Throwable throwable) {
            try {
                c.close();
                throw throwable;
            }
            catch (SQLException | LiquibaseException e) {
                logger.error("Cannot migrate database.", e);
                throw new RuntimeException(e);
            }
        }
        c.close();
        return databaseMigrationState;
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((SupplierClassBinding)this.bindFactory(LiquibaseMigration.class).to(DatabaseMigrationState.class)).in(Singleton.class);
        }
    }
}

