/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.type;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;

public final class BigIntegerType
implements UserType {
    public int[] sqlTypes() {
        return new int[]{-2};
    }

    public Class returnedClass() {
        return BigInteger.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null) {
            return y == null;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        byte[] idAsBytes = rs.getBytes(names[0]);
        if (idAsBytes == null) {
            return null;
        }
        return new BigInteger(idAsBytes);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value != null) {
            BigInteger bigInteger = (BigInteger)value;
            byte[] result = bigInteger.toByteArray();
            if (result.length != 16) {
                byte[] zerofill = new byte[16];
                System.arraycopy(result, 0, zerofill, zerofill.length - result.length, result.length);
                result = zerofill;
            }
            st.setBytes(index, result);
        } else {
            st.setNull(index, -2);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        BigInteger bigInteger = (BigInteger)value;
        return bigInteger.toByteArray();
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        byte[] radixBigint = (byte[])cached;
        return new BigInteger(radixBigint);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

