/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.TimeZone;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;

public final class CalendarTimestampType
implements UserType {
    public int[] sqlTypes() {
        return new int[]{-5};
    }

    public Class returnedClass() {
        return Calendar.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null) {
            return y == null;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        String timeInMillisStr = rs.getString(names[0]);
        if (timeInMillisStr == null) {
            return null;
        }
        Long timeInMillis = Long.valueOf(timeInMillisStr);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(timeInMillis);
        return calendar;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value != null) {
            Calendar calendar = (Calendar)value;
            st.setLong(index, calendar.getTimeInMillis());
        } else {
            st.setNull(index, -5);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        Calendar calendar = (Calendar)value;
        return Long.valueOf(calendar.getTimeInMillis());
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        Long timeInMillis = (Long)cached;
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(timeInMillis);
        return calendar;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

