/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.logging;

import java.util.Optional;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=0)
public final class HttpResponseLoggingFilter
implements ContainerResponseFilter {
    private static Logger logger = LoggerFactory.getLogger(HttpResponseLoggingFilter.class);

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        String method = requestContext.getMethod();
        String path = requestContext.getUriInfo().getPath();
        int status = responseContext.getStatus();
        String message = this.extractResponseMessage(responseContext);
        String logMessage = String.format("%s HTTP %s %s%s", status, method, path, message).trim();
        logger.info(logMessage);
    }

    private String extractResponseMessage(ContainerResponseContext context) {
        Response.Status.Family f = context.getStatusInfo().getFamily();
        if (f.equals((Object)Response.Status.Family.REDIRECTION)) {
            return " -> " + Optional.ofNullable(context.getHeaders()).filter(h -> h.containsKey((Object)"Location")).map(h -> h.getFirst((Object)"Location")).map(Object::toString).orElse("No location header provided");
        }
        if (f.equals((Object)Response.Status.Family.CLIENT_ERROR) || f.equals((Object)Response.Status.Family.SERVER_ERROR)) {
            return ": " + Optional.ofNullable(context.getEntity()).map(e -> (ErrorResponseBuilder.ErrorResponse)e).map(ErrorResponseBuilder.ErrorResponse::getErrorDescription).orElse("No error entity detected.");
        }
        return "";
    }
}

