/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.response;

import java.util.List;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.hibernate.entity.AbstractEntity;
import net.krotscheck.kangaroo.common.response.ListResponseEntity;
import net.krotscheck.kangaroo.common.response.SortOrder;

public final class ListResponseBuilder<T extends AbstractEntity> {
    private Response.ResponseBuilder builder = Response.ok();
    private ListResponseEntity<T> responseEntity = new ListResponseEntity();

    private ListResponseBuilder() {
        this.builder.entity(this.responseEntity);
    }

    public static ListResponseBuilder builder() {
        return new ListResponseBuilder();
    }

    public ListResponseBuilder addResult(List<T> results) {
        this.responseEntity.setResults(results);
        return this;
    }

    public ListResponseBuilder limit(Number limit) {
        this.responseEntity.setLimit(limit);
        this.builder.header("Limit", (Object)limit.longValue());
        return this;
    }

    public ListResponseBuilder total(Number total) {
        this.responseEntity.setTotal(total);
        this.builder.header("Total", (Object)total.longValue());
        return this;
    }

    public ListResponseBuilder total(Object total) {
        return this.total(Long.valueOf(total.toString()));
    }

    public ListResponseBuilder offset(Number offset) {
        this.responseEntity.setOffset(offset);
        this.builder.header("Offset", (Object)offset.longValue());
        return this;
    }

    public ListResponseBuilder sort(String sort) {
        this.responseEntity.setSort(sort);
        this.builder.header("Sort", (Object)sort);
        return this;
    }

    public ListResponseBuilder order(SortOrder order) {
        this.responseEntity.setOrder(order);
        this.builder.header("Order", (Object)order.toString());
        return this;
    }

    public ListResponseBuilder order(String order) {
        return this.order(SortOrder.fromString(order));
    }

    public Response build() {
        return this.builder.build();
    }
}

