/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.security;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import net.krotscheck.kangaroo.common.security.NoCSRFHeaderException;

@Priority(value=1000)
public final class CsrfProtectionFilter
implements ContainerRequestFilter {
    private static final String HEADER = "X-Requested-With";
    private static final Set<String> METHODS_TO_IGNORE = Sets.newHashSet((Object[])new String[]{"GET", "OPTIONS", "HEAD"});

    public void filter(ContainerRequestContext request) {
        if (METHODS_TO_IGNORE.contains(request.getMethod())) {
            return;
        }
        if (request.getHeaders().containsKey((Object)HEADER)) {
            return;
        }
        throw new NoCSRFHeaderException();
    }
}

