/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.swagger;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

@Path(value="/")
@Singleton
public final class SwaggerUIService {
    private final List<String> files = Arrays.asList("favicon-16x16.png", "favicon-32x32.png", "index.html", "oauth2-redirect.html", "swagger-ui.css", "swagger-ui.js", "swagger-ui-bundle.js", "swagger-ui-standalone-preset.js");
    private final ClassLoader classLoader = this.getClass().getClassLoader();

    @GET
    public InputStream getFile() {
        return this.specificFile("index.html");
    }

    @GET
    @Path(value="{path: [^./]+\\.(html|css|js|png)}")
    public InputStream specificFile(@PathParam(value="path") String path) {
        if (!this.files.contains(path)) {
            throw new NotFoundException();
        }
        String resourcePath = String.format("swagger/%s", path);
        return this.classLoader.getResourceAsStream(resourcePath);
    }
}

