/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.timedtasks;

import java.util.List;
import java.util.Timer;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.krotscheck.kangaroo.common.timedtasks.RepeatingTask;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimedTasksLifecycleListener
implements ContainerLifecycleListener {
    private static Logger logger = LoggerFactory.getLogger(TimedTasksLifecycleListener.class);
    private InjectionManager injector;
    private Timer timer;

    @Inject
    public TimedTasksLifecycleListener(InjectionManager injector) {
        this.injector = injector;
    }

    public void onStartup(Container container) {
        logger.info("Starting timer");
        this.timer = new Timer(true);
        List tasks = this.injector.getAllInstances(RepeatingTask.class);
        for (RepeatingTask task : tasks) {
            logger.debug(String.format("Scheduling: %s: %s seconds", task.getClass().getSimpleName(), Math.floor(task.getPeriod() / 1000L)));
            this.timer.scheduleAtFixedRate(task.getTask(), task.getDelay(), task.getPeriod());
        }
    }

    public void onReload(Container container) {
    }

    public void onShutdown(Container container) {
        logger.info("Cancelling timer");
        this.timer.cancel();
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)this.bind(TimedTasksLifecycleListener.class).to(ContainerLifecycleListener.class)).in(Singleton.class);
        }
    }
}

