/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.server;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationBuilder.class);
    private final Options commandlineOptions = new Options();
    private Configuration defaultConfiguration;
    private Configuration cliConfiguration;
    private List<Configuration> fileConfiguration = new ArrayList<Configuration>();

    public ConfigurationBuilder() {
        this.defaultConfiguration = new MapConfiguration(new HashMap());
    }

    public ConfigurationBuilder withDefaults(Map<String, Object> defaults) {
        defaults.forEach((k, v) -> this.defaultConfiguration.setProperty(k, v));
        return this;
    }

    public ConfigurationBuilder withCommandlineOptions(Options options) {
        options.getOptions().forEach(arg_0 -> ((Options)this.commandlineOptions).addOption(arg_0));
        return this;
    }

    public ConfigurationBuilder addCommandlineArgs(String[] args) {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(this.commandlineOptions, args, false);
        }
        catch (ParseException e) {
            HelpFormatter formater = new HelpFormatter();
            formater.setWidth(120);
            formater.printHelp("Main", this.commandlineOptions);
            throw new RuntimeException();
        }
        HashMap<String, String> cliProps = new HashMap<String, String>();
        for (Option o : cmd.getOptions()) {
            cliProps.put(o.getArgName(), o.getValue());
        }
        this.cliConfiguration = new MapConfiguration(cliProps);
        return this;
    }

    public ConfigurationBuilder addPropertiesFile(String path) {
        return this.addPropertiesFile(new File(path));
    }

    public ConfigurationBuilder addPropertiesFile(File file) {
        if (file.exists()) {
            try {
                LOGGER.info(String.format("Loading configuration: %s", file.getAbsolutePath()));
                PropertiesConfiguration c = new PropertiesConfiguration(file);
                this.fileConfiguration.add((Configuration)c);
            }
            catch (ConfigurationException ce) {
                LOGGER.warn(String.format("Unable to read properties file: %s", file.getAbsolutePath()));
            }
        }
        return this;
    }

    public Configuration build() {
        CompositeConfiguration config = new CompositeConfiguration();
        if (this.cliConfiguration != null) {
            config.addConfiguration(this.cliConfiguration);
        }
        config.addConfiguration((Configuration)new SystemConfiguration());
        this.fileConfiguration.forEach(arg_0 -> ((CompositeConfiguration)config).addConfiguration(arg_0));
        config.addConfiguration((Configuration)new EnvironmentConfiguration());
        config.addConfiguration(this.defaultConfiguration);
        return config;
    }
}

