/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.server;

import java.io.File;
import net.krotscheck.kangaroo.server.SecurityHeaders;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.StaticHttpHandlerBase;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;

public final class HtmlApplicationHttpHandler
extends StaticHttpHandlerBase {
    private final File docRoot;
    private final File indexResource;

    public HtmlApplicationHttpHandler(String docRoot) {
        this.docRoot = new File(docRoot);
        this.indexResource = new File(this.docRoot, "/index.html");
        if (!this.indexResource.exists()) {
            throw new RuntimeException("docRoot does not contain index.html");
        }
    }

    protected boolean handle(String uri, Request request, Response response) throws Exception {
        if (!Method.GET.equals(request.getMethod())) {
            response.setStatus(HttpStatus.METHOD_NOT_ALLOWED_405);
            response.setHeader(Header.Allow, "GET");
            return true;
        }
        File resource = new File(this.docRoot, uri);
        boolean exists = resource.exists();
        boolean isDirectory = resource.isDirectory();
        if (!exists || isDirectory) {
            resource = this.indexResource;
        }
        SecurityHeaders.ALL.forEach((arg_0, arg_1) -> ((Response)response).addHeader(arg_0, arg_1));
        HtmlApplicationHttpHandler.pickupContentType((Response)response, (String)resource.getPath());
        this.addToFileCache(request, response, resource);
        HtmlApplicationHttpHandler.sendFile((Response)response, (File)resource);
        return true;
    }
}

