/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.server;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import net.krotscheck.kangaroo.common.config.ConfigurationBinder;
import net.krotscheck.kangaroo.server.Config;
import net.krotscheck.kangaroo.server.ConfigurationBuilder;
import net.krotscheck.kangaroo.server.HtmlApplicationHttpHandler;
import net.krotscheck.kangaroo.server.KangarooErrorPageGenerator;
import net.krotscheck.kangaroo.server.keystore.FSKeystoreProvider;
import net.krotscheck.kangaroo.server.keystore.GeneratedKeystoreProvider;
import net.krotscheck.kangaroo.server.keystore.IKeystoreProvider;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.glassfish.grizzly.http.server.ErrorPageGenerator;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.jersey.process.JerseyProcessingUncaughtExceptionHandler;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public final class ServerFactory {
    public static final Options CLI_OPTIONS = new Options();
    private final List<ServerOperator> serverLambdas = new ArrayList<ServerOperator>();
    private ConfigurationBuilder configBuilder = new ConfigurationBuilder();
    private Map<String, ResourceConfig> services = new HashMap<String, ResourceConfig>();

    public ServerFactory() {
        this.withCommandlineOptions(CLI_OPTIONS);
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put(Config.HOST.getKey(), Config.HOST.getValue());
        defaults.put(Config.PORT.getKey(), Config.PORT.getValue());
        this.configBuilder.withDefaults(defaults);
    }

    public ServerFactory withCommandlineOptions(Options options) {
        this.configBuilder.withCommandlineOptions(options);
        return this;
    }

    public ServerFactory withCommandlineArgs(String[] args) {
        this.configBuilder.addCommandlineArgs(args);
        return this;
    }

    public ServerFactory withPropertiesFile(String path) {
        this.configBuilder.addPropertiesFile(path);
        return this;
    }

    public ServerFactory withResource(String s, ResourceConfig resource) {
        this.services.put(s, resource);
        return this;
    }

    public HttpServer build() {
        Configuration config = this.configBuilder.build();
        HttpServer server = this.createServer(config);
        for (Map.Entry<String, ResourceConfig> route : this.services.entrySet()) {
            String path = route.getKey();
            ResourceConfig rc = route.getValue();
            rc.register((Object)new ConfigurationBinder(config));
            String name = route.getValue().getClass().getSimpleName();
            WebappContext context = new WebappContext(name, path);
            ServletRegistration registration = context.addServlet(name, (Servlet)new ServletContainer(rc));
            registration.setInitParameter("swagger.context.id", name);
            registration.addMapping(new String[]{String.format("%s/*", path)});
            context.deploy(server);
        }
        String htmlAppRoot = config.getString(Config.HTML_APP_ROOT.getKey(), Config.HTML_APP_ROOT.getValue());
        if (!Strings.isNullOrEmpty((String)htmlAppRoot)) {
            HtmlApplicationHttpHandler handler = new HtmlApplicationHttpHandler(htmlAppRoot);
            handler.setFileCacheEnabled(true);
            server.getServerConfiguration().addHttpHandler((HttpHandler)handler, new String[]{"/*"});
        }
        return server;
    }

    private HttpServer createServer(Configuration config) {
        URI serverUri = this.getServerUri(config);
        SSLEngineConfigurator configurator = this.buildSSLConfigurator(config);
        NetworkListener listener = new NetworkListener("kangaroo", serverUri.getHost(), serverUri.getPort());
        listener.getTransport().getWorkerThreadPoolConfig().setThreadFactory(new ThreadFactoryBuilder().setNameFormat("kangaroo-http-server-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new JerseyProcessingUncaughtExceptionHandler()).build());
        listener.setSecure(true);
        listener.setSSLEngineConfig(configurator);
        HttpServer server = new HttpServer();
        server.addListener(listener);
        ServerConfiguration serverConfiguration = server.getServerConfiguration();
        serverConfiguration.setHttpServerName(null);
        serverConfiguration.setHttpServerVersion(null);
        serverConfiguration.setPassTraceRequest(true);
        serverConfiguration.setDefaultQueryEncoding(Charsets.UTF8_CHARSET);
        serverConfiguration.setDefaultErrorPageGenerator((ErrorPageGenerator)new KangarooErrorPageGenerator());
        this.serverLambdas.forEach(s -> s.operation(server));
        return server;
    }

    private IKeystoreProvider getKeystore(String workingDir, String ksPath, String ksPass, String ksType, String certAlias, String certPass) {
        if (StringUtils.isEmpty((CharSequence)ksPath)) {
            return new GeneratedKeystoreProvider(workingDir, ksPass, certPass, certAlias);
        }
        return new FSKeystoreProvider(ksPath, ksPass, ksType);
    }

    private SSLEngineConfigurator buildSSLConfigurator(Configuration config) {
        String ksPath = config.getString(Config.KEYSTORE_PATH.getKey(), Config.KEYSTORE_PATH.getValue());
        String ksPass = config.getString(Config.KEYSTORE_PASS.getKey(), Config.KEYSTORE_PASS.getValue());
        String ksType = config.getString(Config.KEYSTORE_TYPE.getKey(), Config.KEYSTORE_TYPE.getValue());
        String certAlias = config.getString(Config.CERT_ALIAS.getKey(), Config.CERT_ALIAS.getValue());
        String certPass = config.getString(Config.CERT_KEY_PASS.getKey(), Config.CERT_KEY_PASS.getValue());
        String workingDir = config.getString(Config.WORKING_DIR.getKey(), Config.WORKING_DIR.getValue());
        IKeystoreProvider ksProvider = this.getKeystore(workingDir, ksPath, ksPass, ksType, certAlias, certPass);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ksProvider.writeTo(baos);
        SSLContextConfigurator sslCon = new SSLContextConfigurator();
        sslCon.setKeyStoreBytes(baos.toByteArray());
        sslCon.setKeyPass(certPass);
        sslCon.setKeyStorePass(ksPass);
        SSLEngineConfigurator sslConf = new SSLEngineConfigurator(sslCon);
        sslConf.setClientMode(false);
        sslConf.setNeedClientAuth(false);
        return sslConf;
    }

    private URI getServerUri(Configuration config) {
        String host = config.getString(Config.HOST.getKey(), Config.HOST.getValue());
        Integer port = config.getInt(Config.PORT.getKey(), Config.PORT.getValue().intValue());
        String scheme = "http";
        URIBuilder builder = new URIBuilder();
        builder.setHost(host);
        builder.setPort(port.intValue());
        builder.setScheme(scheme);
        builder.setPath("/");
        try {
            return builder.build();
        }
        catch (URISyntaxException use) {
            throw new RuntimeException("Cannot construct server URI", use);
        }
    }

    public ServerFactory configureServer(ServerOperator serverLambda) {
        this.serverLambdas.add(serverLambda);
        return this;
    }

    static {
        Option bindHost = Option.builder((String)"h").longOpt(Config.HOST.getKey()).argName(Config.HOST.getKey()).hasArg().desc("The IP address or hostname which this server should bind to.").build();
        Option bindPort = Option.builder((String)"p").longOpt(Config.PORT.getKey()).argName(Config.PORT.getKey()).hasArg().desc("The port on which this port should listen.").build();
        Option workingDir = Option.builder().longOpt(Config.WORKING_DIR.getKey()).argName(Config.WORKING_DIR.getKey()).hasArg().desc("The server's working directory.").build();
        Option keystorePath = Option.builder().longOpt(Config.KEYSTORE_PATH.getKey()).argName(Config.KEYSTORE_PATH.getKey()).hasArg().desc("Path to an externally provided keystore.").build();
        Option keystorePass = Option.builder().longOpt(Config.KEYSTORE_PASS.getKey()).argName(Config.KEYSTORE_PASS.getKey()).hasArg().desc("Password for the externally provided keystore.").build();
        Option keystoreType = Option.builder().longOpt(Config.KEYSTORE_TYPE.getKey()).argName(Config.KEYSTORE_TYPE.getKey()).hasArg().desc("JVM KeyStore type to expect. Default PKCS12.").build();
        Option certAlias = Option.builder().longOpt(Config.CERT_ALIAS.getKey()).argName(Config.CERT_ALIAS.getKey()).hasArg().desc("Alias of the HTTPS certificate to use.").build();
        Option certKeyPass = Option.builder().longOpt(Config.CERT_KEY_PASS.getKey()).argName(Config.CERT_KEY_PASS.getKey()).hasArg().desc("Password of the private key for the certificate.").build();
        Option htmlAppRoot = Option.builder().longOpt(Config.HTML_APP_ROOT.getKey()).argName(Config.HTML_APP_ROOT.getKey()).hasArg().desc("Path to the server's HTML5 Application root. We presume HTML5 routing support in the application served there.").build();
        CLI_OPTIONS.addOption(bindHost);
        CLI_OPTIONS.addOption(bindPort);
        CLI_OPTIONS.addOption(workingDir);
        CLI_OPTIONS.addOption(keystorePath);
        CLI_OPTIONS.addOption(keystorePass);
        CLI_OPTIONS.addOption(keystoreType);
        CLI_OPTIONS.addOption(certAlias);
        CLI_OPTIONS.addOption(certKeyPass);
        CLI_OPTIONS.addOption(htmlAppRoot);
    }

    public static interface ServerOperator {
        public void operation(HttpServer var1);
    }
}

