/*
 * Decompiled with CFR 0.152.
 */
package net.libyaguide.gpay.sdk.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.libyaguide.gpay.sdk.crypto.HashTokenGenerator;
import net.libyaguide.gpay.sdk.crypto.ResponseVerifier;
import net.libyaguide.gpay.sdk.crypto.VerificationHashGenerator;
import net.libyaguide.gpay.sdk.model.Balance;
import net.libyaguide.gpay.sdk.model.OperationType;
import net.libyaguide.gpay.sdk.model.OutstandingTransaction;
import net.libyaguide.gpay.sdk.model.OutstandingTransactions;
import net.libyaguide.gpay.sdk.model.PaymentRequest;
import net.libyaguide.gpay.sdk.model.PaymentStatus;
import net.libyaguide.gpay.sdk.model.SendMoneyResult;
import net.libyaguide.gpay.sdk.model.Statement;
import net.libyaguide.gpay.sdk.model.StatementTransaction;
import net.libyaguide.gpay.sdk.model.TransactionStatus;
import net.libyaguide.gpay.sdk.model.WalletCheck;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class GPayApiClient {
    private final String apiKey;
    private final String secretKey;
    private final String password;
    private final String baseUrl;
    private final OkHttpClient httpClient;
    private final Gson gson;
    private final String language;

    public GPayApiClient(String apiKey, String secretKey, String password, BaseUrl baseUrl, String language) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.password = password;
        this.baseUrl = baseUrl.getUrl();
        this.language = language == null || language.isEmpty() ? "en" : language;
        this.httpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
        this.gson = new Gson();
    }

    public GPayApiClient(String apiKey, String secretKey, String password, BaseUrl baseUrl) {
        this(apiKey, secretKey, password, baseUrl, "en");
    }

    private Headers buildHeaders(String salt, String verificationHash, String language) {
        return new Headers.Builder().add("Authorization", "Bearer " + this.apiKey).add("Accept-Language", language).add("X-Signature-Salt", salt).add("X-Signature-Hash", verificationHash).build();
    }

    private ApiResponse sendRequest(String endpoint, Map<String, String> params) throws Exception {
        String salt = HashTokenGenerator.generateSalt();
        String hashToken = HashTokenGenerator.generateHashToken(salt, this.password);
        String verificationHash = VerificationHashGenerator.generateVerificationHash(hashToken, params, this.secretKey);
        Headers headers = this.buildHeaders(salt, verificationHash, this.language);
        String jsonBody = this.gson.toJson(params);
        RequestBody body = RequestBody.create((String)jsonBody, (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(this.baseUrl + endpoint).headers(headers).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new RuntimeException("HTTP error: " + response.code() + " - " + response.message());
            }
            HashMap headerMap = new HashMap();
            response.headers().toMultimap().forEach((k, v) -> headerMap.put(k.toLowerCase(), String.join((CharSequence)",", v)));
            ApiResponse apiResponse = new ApiResponse(response.body().string(), headerMap, response.code());
            return apiResponse;
        }
    }

    public Balance getWalletBalance() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("request_timestamp", String.valueOf(System.currentTimeMillis()));
        ApiResponse apiResponse = this.sendRequest("/info/balance", params);
        JsonObject data = ((JsonObject)this.gson.fromJson(apiResponse.response, JsonObject.class)).getAsJsonObject("data");
        HashMap<String, String> verifyFields = new HashMap<String, String>();
        verifyFields.put("balance", data.get("balance").getAsString());
        verifyFields.put("response_timestamp", data.get("response_timestamp").getAsString());
        if (!ResponseVerifier.verifyResponse(this.secretKey, this.password, apiResponse, verifyFields)) {
            throw new SecurityException("Response verification failed for getWalletBalance");
        }
        Balance balance = new Balance();
        balance.setBalance(new BigDecimal(data.get("balance").getAsString()));
        balance.setResponseTimestamp(new Date(Long.parseLong(data.get("response_timestamp").getAsString())));
        return balance;
    }

    public PaymentRequest createPaymentRequest(BigDecimal amount, String referenceNo, String description) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("amount", amount.toString());
        params.put("reference_no", referenceNo == null ? "" : referenceNo);
        params.put("description", description == null ? "" : description);
        params.put("request_timestamp", String.valueOf(System.currentTimeMillis()));
        ApiResponse apiResponse = this.sendRequest("/payment/create-payment-request", params);
        JsonObject data = ((JsonObject)this.gson.fromJson(apiResponse.response, JsonObject.class)).getAsJsonObject("data");
        HashMap<String, String> verifyFields = new HashMap<String, String>();
        verifyFields.put("requester_username", data.get("requester_username").getAsString());
        verifyFields.put("request_id", data.get("request_id").getAsString());
        verifyFields.put("request_time", data.get("request_time").getAsString());
        verifyFields.put("amount", data.get("amount").getAsString());
        verifyFields.put("reference_no", data.has("reference_no") && !data.get("reference_no").isJsonNull() ? data.get("reference_no").getAsString() : "");
        verifyFields.put("response_timestamp", data.get("response_timestamp").getAsString());
        if (!ResponseVerifier.verifyResponse(this.secretKey, this.password, apiResponse, verifyFields)) {
            throw new SecurityException("Response verification failed for createPaymentRequest");
        }
        PaymentRequest req = new PaymentRequest();
        req.setRequesterUsername(data.get("requester_username").getAsString());
        req.setRequestId(data.get("request_id").getAsString());
        req.setRequestTime(new Date(Long.parseLong(data.get("request_time").getAsString())));
        req.setAmount(new BigDecimal(data.get("amount").getAsString()));
        req.setReferenceNo(data.has("reference_no") && !data.get("reference_no").isJsonNull() ? data.get("reference_no").getAsString() : null);
        req.setResponseTimestamp(new Date(Long.parseLong(data.get("response_timestamp").getAsString())));
        return req;
    }

    public PaymentStatus checkPaymentStatus(String requestId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("request_id", requestId);
        params.put("request_timestamp", String.valueOf(System.currentTimeMillis()));
        ApiResponse apiResponse = this.sendRequest("/payment/check-payment-status", params);
        JsonObject data = ((JsonObject)this.gson.fromJson(apiResponse.response, JsonObject.class)).getAsJsonObject("data");
        HashMap<String, String> verifyFields = new HashMap<String, String>();
        verifyFields.put("request_id", data.get("request_id").getAsString());
        verifyFields.put("transaction_id", data.has("transaction_id") && !data.get("transaction_id").isJsonNull() ? data.get("transaction_id").getAsString() : "");
        verifyFields.put("amount", data.get("amount").getAsString());
        verifyFields.put("payment_timestamp", data.has("payment_timestamp") && !data.get("payment_timestamp").isJsonNull() ? data.get("payment_timestamp").getAsString() : "");
        verifyFields.put("reference_no", data.has("reference_no") && !data.get("reference_no").isJsonNull() ? data.get("reference_no").getAsString() : "");
        verifyFields.put("description", data.has("description") && !data.get("description").isJsonNull() ? data.get("description").getAsString() : "");
        verifyFields.put("is_paid", data.has("is_paid") && !data.get("is_paid").isJsonNull() ? String.valueOf(data.get("is_paid").getAsBoolean()) : "");
        verifyFields.put("response_timestamp", data.get("response_timestamp").getAsString());
        if (!ResponseVerifier.verifyResponse(this.secretKey, this.password, apiResponse, verifyFields)) {
            throw new SecurityException("Response verification failed for checkPaymentStatus");
        }
        PaymentStatus status = new PaymentStatus();
        status.setRequestId(data.get("request_id").getAsString());
        status.setTransactionId(data.has("transaction_id") && !data.get("transaction_id").isJsonNull() ? data.get("transaction_id").getAsString() : null);
        status.setAmount(new BigDecimal(data.get("amount").getAsString()));
        status.setPaymentTimestamp(data.has("payment_timestamp") && !data.get("payment_timestamp").isJsonNull() ? new Date(Long.parseLong(data.get("payment_timestamp").getAsString())) : null);
        status.setReferenceNo(data.has("reference_no") && !data.get("reference_no").isJsonNull() ? data.get("reference_no").getAsString() : null);
        status.setDescription(data.has("description") && !data.get("description").isJsonNull() ? data.get("description").getAsString() : null);
        status.setPaid(data.get("is_paid").getAsBoolean());
        status.setResponseTimestamp(new Date(Long.parseLong(data.get("response_timestamp").getAsString())));
        return status;
    }

    public SendMoneyResult sendMoney(BigDecimal amount, String walletGatewayId, String referenceNo, String description) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("amount", amount.toString());
        params.put("wallet_gateway_id", walletGatewayId);
        params.put("reference_no", referenceNo == null ? "" : referenceNo);
        params.put("description", description == null ? "" : description);
        params.put("request_timestamp", String.valueOf(System.currentTimeMillis()));
        ApiResponse apiResponse = this.sendRequest("/payment/send-money", params);
        JsonObject data = ((JsonObject)this.gson.fromJson(apiResponse.response, JsonObject.class)).getAsJsonObject("data");
        HashMap<String, String> verifyFields = new HashMap<String, String>();
        verifyFields.put("amount", data.get("amount").getAsString());
        verifyFields.put("sender_fee", data.get("sender_fee").getAsString());
        verifyFields.put("transaction_id", data.get("transaction_id").getAsString());
        verifyFields.put("old_balance", data.get("old_balance").getAsString());
        verifyFields.put("new_balance", data.get("new_balance").getAsString());
        verifyFields.put("timestamp", data.get("timestamp").getAsString());
        verifyFields.put("reference_no", data.has("reference_no") && !data.get("reference_no").isJsonNull() ? data.get("reference_no").getAsString() : "");
        verifyFields.put("response_timestamp", data.get("response_timestamp").getAsString());
        if (!ResponseVerifier.verifyResponse(this.secretKey, this.password, apiResponse, verifyFields)) {
            throw new SecurityException("Response verification failed for sendMoney");
        }
        SendMoneyResult result = new SendMoneyResult();
        result.setAmount(new BigDecimal(data.get("amount").getAsString()));
        result.setSenderFee(new BigDecimal(data.get("sender_fee").getAsString()));
        result.setTransactionId(data.get("transaction_id").getAsString());
        result.setOldBalance(new BigDecimal(data.get("old_balance").getAsString()));
        result.setNewBalance(new BigDecimal(data.get("new_balance").getAsString()));
        result.setTimestamp(new Date(Long.parseLong(data.get("timestamp").getAsString())));
        result.setReferenceNo(data.has("reference_no") && !data.get("reference_no").isJsonNull() ? data.get("reference_no").getAsString() : null);
        result.setResponseTimestamp(new Date(Long.parseLong(data.get("response_timestamp").getAsString())));
        return result;
    }

    public Statement getStatement(String date) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("date", date);
        params.put("request_timestamp", String.valueOf(System.currentTimeMillis()));
        ApiResponse apiResponse = this.sendRequest("/info/statement", params);
        JsonObject data = ((JsonObject)this.gson.fromJson(apiResponse.response, JsonObject.class)).getAsJsonObject("data");
        HashMap<String, String> verifyFields = new HashMap<String, String>();
        verifyFields.put("available_balance", data.get("available_balance").getAsString());
        verifyFields.put("outstanding_credit", data.get("outstanding_credit").getAsString());
        verifyFields.put("outstanding_debit", data.get("outstanding_debit").getAsString());
        verifyFields.put("day_balance", data.get("day_balance").getAsString());
        verifyFields.put("day_total_in", data.get("day_total_in").getAsString());
        verifyFields.put("day_total_out", data.get("day_total_out").getAsString());
        verifyFields.put("response_timestamp", data.get("response_timestamp").getAsString());
        if (!ResponseVerifier.verifyResponse(this.secretKey, this.password, apiResponse, verifyFields)) {
            throw new SecurityException("Response verification failed for getStatement");
        }
        Statement statement = new Statement();
        statement.setAvailableBalance(new BigDecimal(data.get("available_balance").getAsString()));
        statement.setOutstandingCredit(new BigDecimal(data.get("outstanding_credit").getAsString()));
        statement.setOutstandingDebit(new BigDecimal(data.get("outstanding_debit").getAsString()));
        statement.setDayBalance(new BigDecimal(data.get("day_balance").getAsString()));
        statement.setDayTotalIn(new BigDecimal(data.get("day_total_in").getAsString()));
        statement.setDayTotalOut(new BigDecimal(data.get("day_total_out").getAsString()));
        statement.setResponseTimestamp(new Date(Long.parseLong(data.get("response_timestamp").getAsString())));
        ArrayList<StatementTransaction> txs = new ArrayList<StatementTransaction>();
        if (data.has("day_statement") && data.get("day_statement").isJsonArray()) {
            for (JsonElement el : data.getAsJsonArray("day_statement")) {
                JsonObject tx = el.getAsJsonObject();
                StatementTransaction stx = new StatementTransaction();
                stx.setTransactionId(tx.get("transaction_id").getAsString());
                stx.setDatetime(tx.get("datetime").getAsString());
                stx.setTimestamp(tx.has("timestamp") && !tx.get("timestamp").isJsonNull() ? new Date(Long.parseLong(tx.get("timestamp").getAsString())) : null);
                stx.setDescription(tx.has("description") && !tx.get("description").isJsonNull() ? tx.get("description").getAsString() : null);
                stx.setAmount(tx.has("amount") && !tx.get("amount").isJsonNull() ? new BigDecimal(tx.get("amount").getAsString()) : null);
                stx.setBalance(tx.has("balance") && !tx.get("balance").isJsonNull() ? new BigDecimal(tx.get("balance").getAsString()) : null);
                stx.setReferenceNo(tx.has("reference_no") && !tx.get("reference_no").isJsonNull() ? tx.get("reference_no").getAsString() : null);
                stx.setOpTypeId(tx.has("op_type_id") && !tx.get("op_type_id").isJsonNull() ? OperationType.fromValue(tx.get("op_type_id").getAsInt()) : null);
                stx.setStatus(tx.has("status") && !tx.get("status").isJsonNull() ? TransactionStatus.fromValue(tx.get("status").getAsInt()) : null);
                stx.setCreatedAt(tx.has("created_at") && !tx.get("created_at").isJsonNull() ? new Date(Long.parseLong(tx.get("created_at").getAsString())) : null);
                txs.add(stx);
            }
        }
        statement.setDayStatement(txs);
        return statement;
    }

    public WalletCheck checkWallet(String walletGatewayId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("wallet_gateway_id", walletGatewayId);
        params.put("request_timestamp", String.valueOf(System.currentTimeMillis()));
        ApiResponse apiResponse = this.sendRequest("/info/check-wallet", params);
        JsonObject data = ((JsonObject)this.gson.fromJson(apiResponse.response, JsonObject.class)).getAsJsonObject("data");
        HashMap<String, String> verifyFields = new HashMap<String, String>();
        verifyFields.put("exists", String.valueOf(data.get("exists").getAsBoolean()));
        verifyFields.put("wallet_gateway_id", data.get("wallet_gateway_id").getAsString());
        verifyFields.put("wallet_name", data.has("wallet_name") && !data.get("wallet_name").isJsonNull() ? data.get("wallet_name").getAsString() : "");
        verifyFields.put("user_account_name", data.has("user_account_name") && !data.get("user_account_name").isJsonNull() ? data.get("user_account_name").getAsString() : "");
        verifyFields.put("can_receive_money", String.valueOf(data.get("can_receive_money").getAsBoolean()));
        verifyFields.put("response_timestamp", data.get("response_timestamp").getAsString());
        if (!ResponseVerifier.verifyResponse(this.secretKey, this.password, apiResponse, verifyFields)) {
            throw new SecurityException("Response verification failed for checkWallet");
        }
        WalletCheck check = new WalletCheck();
        check.setExists(data.get("exists").getAsBoolean());
        check.setWalletGatewayId(data.get("wallet_gateway_id").getAsString());
        check.setWalletName(data.has("wallet_name") && !data.get("wallet_name").isJsonNull() ? data.get("wallet_name").getAsString() : null);
        check.setUserAccountName(data.has("user_account_name") && !data.get("user_account_name").isJsonNull() ? data.get("user_account_name").getAsString() : null);
        check.setCanReceiveMoney(data.get("can_receive_money").getAsBoolean());
        check.setResponseTimestamp(new Date(Long.parseLong(data.get("response_timestamp").getAsString())));
        return check;
    }

    public OutstandingTransactions getOutstandingTransactions() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("request_timestamp", String.valueOf(System.currentTimeMillis()));
        ApiResponse apiResponse = this.sendRequest("/info/outstanding-transactions", params);
        JsonObject data = ((JsonObject)this.gson.fromJson(apiResponse.response, JsonObject.class)).getAsJsonObject("data");
        HashMap<String, String> verifyFields = new HashMap<String, String>();
        verifyFields.put("outstanding_credit", data.get("outstanding_credit").getAsString());
        verifyFields.put("outstanding_debit", data.get("outstanding_debit").getAsString());
        verifyFields.put("response_timestamp", data.get("response_timestamp").getAsString());
        if (!ResponseVerifier.verifyResponse(this.secretKey, this.password, apiResponse, verifyFields)) {
            throw new SecurityException("Response verification failed for getOutstandingTransactions");
        }
        OutstandingTransactions outstanding = new OutstandingTransactions();
        outstanding.setOutstandingCredit(new BigDecimal(data.get("outstanding_credit").getAsString()));
        outstanding.setOutstandingDebit(new BigDecimal(data.get("outstanding_debit").getAsString()));
        outstanding.setResponseTimestamp(new Date(Long.parseLong(data.get("response_timestamp").getAsString())));
        ArrayList<OutstandingTransaction> txs = new ArrayList<OutstandingTransaction>();
        if (data.has("outstanding_transactions") && data.get("outstanding_transactions").isJsonArray()) {
            for (JsonElement el : data.getAsJsonArray("outstanding_transactions")) {
                JsonObject tx = el.getAsJsonObject();
                OutstandingTransaction otx = new OutstandingTransaction();
                otx.setTransactionId(tx.get("transaction_id").getAsString());
                otx.setDatetime(tx.get("datetime").getAsString());
                otx.setTimestamp(tx.has("timestamp") && !tx.get("timestamp").isJsonNull() ? new Date(Long.parseLong(tx.get("timestamp").getAsString())) : null);
                otx.setDescription(tx.has("description") && !tx.get("description").isJsonNull() ? tx.get("description").getAsString() : null);
                otx.setAmount(tx.has("amount") && !tx.get("amount").isJsonNull() ? new BigDecimal(tx.get("amount").getAsString()) : null);
                otx.setBalance(tx.has("balance") && !tx.get("balance").isJsonNull() ? new BigDecimal(tx.get("balance").getAsString()) : null);
                otx.setReferenceNo(tx.has("reference_no") && !tx.get("reference_no").isJsonNull() ? tx.get("reference_no").getAsString() : null);
                otx.setOpTypeId(tx.has("op_type_id") && !tx.get("op_type_id").isJsonNull() ? OperationType.fromValue(tx.get("op_type_id").getAsInt()) : null);
                otx.setStatus(tx.has("status") && !tx.get("status").isJsonNull() ? TransactionStatus.fromValue(tx.get("status").getAsInt()) : null);
                otx.setCreatedAt(tx.has("created_at") && !tx.get("created_at").isJsonNull() ? new Date(Long.parseLong(tx.get("created_at").getAsString())) : null);
                txs.add(otx);
            }
        }
        outstanding.setOutstandingTransactions(txs);
        return outstanding;
    }

    public static enum BaseUrl {
        STAGING("https://gpay-staging.libyaguide.net/banking/api/onlinewallet/v1"),
        PRODUCTION("https://gpay.ly/banking/api/onlinewallet/v1");

        private final String url;

        private BaseUrl(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }
    }

    public class ApiResponse {
        public final String response;
        public final Map<String, String> headers;
        public final int code;

        private ApiResponse(String response, Map<String, String> headers, int code) {
            this.response = response;
            this.headers = headers;
            this.code = code;
        }

        public JsonObject getJsonResponse() {
            return (JsonObject)GPayApiClient.this.gson.fromJson(this.response, JsonObject.class);
        }

        public String toString() {
            return this.response;
        }
    }
}

