/*
 * Decompiled with CFR 0.152.
 */
package net.libyaguide.gpay.sdk.crypto;

import java.util.Map;
import net.libyaguide.gpay.sdk.client.GPayApiClient;
import net.libyaguide.gpay.sdk.crypto.VerificationHashGenerator;

public class ResponseVerifier {
    public static boolean verifyResponse(String secretKey, String password, GPayApiClient.ApiResponse response, Map<String, String> responseFields) throws Exception {
        String salt = response.headers.get("x-signature-salt");
        String receivedHash = response.headers.get("x-signature-hash");
        String hashToken = salt + password;
        String generatedHash = VerificationHashGenerator.generateVerificationHash(hashToken, responseFields, secretKey);
        return generatedHash.equals(receivedHash);
    }
}

