/*
 * Decompiled with CFR 0.152.
 */
package net.libyaguide.gpay.sdk.crypto;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class VerificationHashGenerator {
    public static String generateHmacSHA256(String data, String secretKey) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(secretKey.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] hash = sha256_HMAC.doFinal(data.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(hash);
    }

    public static String generateVerificationHash(String hashToken, Map<String, String> params, String secretKey) throws Exception {
        TreeMap<String, String> sorted = new TreeMap<String, String>(params);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : sorted.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(entry.getKey()).append("=");
            String value = entry.getValue();
            if (value == null) continue;
            sb.append(value);
        }
        String verificationString = hashToken + sb.toString();
        return VerificationHashGenerator.generateHmacSHA256(verificationString, secretKey);
    }
}

