/*
 * Decompiled with CFR 0.152.
 */
package net.magik6k.bitbuffer;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;

public abstract class BitBuffer {
    public abstract BitBuffer putBoolean(boolean var1);

    public abstract BitBuffer putByte(byte var1);

    public abstract BitBuffer putByte(byte var1, int var2);

    public BitBuffer putInt(int i) {
        this.putByte((byte)((i & 0xFF000000) >>> 24));
        this.putByte((byte)((i & 0xFF0000) >>> 16));
        this.putByte((byte)((i & 0xFF00) >>> 8));
        this.putByte((byte)(i & 0xFF));
        return this;
    }

    public BitBuffer putInt(int i, int bits) {
        if (bits == 0) {
            return this;
        }
        do {
            if (bits > 7) {
                this.putByte((byte)((i & 255 << bits - 8) >>> bits - 8));
                bits -= 8;
                continue;
            }
            this.putByte((byte)(i & 255 >> -(bits - 8)), bits);
            bits = 0;
        } while (bits > 0);
        return this;
    }

    public BitBuffer putFloat(float f) {
        int asInt = Float.floatToRawIntBits(f);
        this.putInt(asInt);
        return this;
    }

    public BitBuffer putString(String s) {
        for (byte ch : s.getBytes(Charsets.UTF_8)) {
            this.putByte(ch);
        }
        return this;
    }

    public BitBuffer putString(String s, int bitsPerChar) {
        for (byte ch : s.getBytes(Charsets.UTF_8)) {
            this.putByte(ch, bitsPerChar);
        }
        return this;
    }

    public abstract boolean getBoolean();

    public abstract byte getByte();

    public abstract byte getByte(int var1);

    public int getInt() {
        return (this.getByte() & 0xFF) << 24 | (this.getByte() & 0xFF) << 16 | (this.getByte() & 0xFF) << 8 | this.getByte() & 0xFF;
    }

    public int getInt(int bits) {
        if (bits == 0) {
            return 0;
        }
        int res = 0;
        do {
            if (bits > 7) {
                res = res << 8 | this.getByte() & 0xFF;
                bits -= 8;
                continue;
            }
            res = (res << bits) + (this.getByte(bits) & 0xFF);
            bits -= bits;
        } while (bits > 0);
        return res;
    }

    public float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    public String getString(int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.getByte();
        }
        return new String(bytes, Charsets.UTF_8);
    }

    public String getString(int length, int bitsPerChar) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.getByte(bitsPerChar);
        }
        return new String(bytes, Charsets.UTF_8);
    }

    public abstract void flip();

    public abstract boolean canRead();

    public abstract boolean canWrite();

    public byte[] asByteArray() {
        if (!this.canRead()) {
            throw new IllegalStateException("BitBuffer cannot be read");
        }
        byte[] result = new byte[this.limit()];
        int startPos = this.position();
        this.setPosition(0);
        for (int i = 0; i < this.limit(); ++i) {
            result[i] = this.getByte();
        }
        this.setPosition(startPos);
        return result;
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.asByteArray());
    }

    public BitBuffer putToByteBuffer(ByteBuffer bb) {
        bb.put(this.asByteArray());
        return this;
    }

    public abstract int size();

    public abstract int limit();

    public abstract int position();

    public abstract BitBuffer setPosition(int var1);

    public static BitBuffer allocate(int bits) {
        return new SimpleBitBuffer(bits);
    }

    protected static class SimpleBitBuffer
    extends BitBuffer {
        private byte[] bytes;
        private boolean read = false;
        private int position;
        private int limit;

        protected SimpleBitBuffer(int bits) {
            this.bytes = new byte[bits / 8];
            this.limit = bits;
        }

        protected SimpleBitBuffer(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public BitBuffer putBoolean(boolean b) {
            this.bytes[this.position / 8] = (byte)((this.bytes[this.position / 8] & ~(128 >>> this.position % 8)) + ((b ? 128 : 0) >>> this.position % 8));
            ++this.position;
            return this;
        }

        @Override
        public BitBuffer putByte(byte b) {
            byte old = (byte)(this.bytes[this.position / 8] & (byte)(~(255 >>> this.position % 8)));
            this.bytes[this.position / 8] = (byte)(old | (byte)((b & 0xFF) >>> this.position % 8));
            if (this.position % 8 > 0) {
                this.bytes[this.position / 8 + 1] = (byte)((b & 0xFF) << 8 - this.position % 8);
            }
            this.position += 8;
            return this;
        }

        @Override
        public BitBuffer putByte(byte b, int bits) {
            b = (byte)(0xFF & (b & 255 >>> 8 - bits) << 8 - bits);
            this.bytes[this.position / 8] = (byte)(0xFF & (this.bytes[this.position / 8] & 255 << 8 - this.position % 8 | (b & 0xFF) >>> this.position % 8));
            if (8 - this.position % 8 < bits) {
                this.bytes[this.position / 8 + 1] = (byte)(0xFF & (b & 0xFF) << 8 - this.position % 8);
            }
            this.position += bits;
            return this;
        }

        @Override
        public boolean getBoolean() {
            boolean result = (this.bytes[this.position / 8] & 128 >>> this.position % 8) > 0;
            ++this.position;
            return result;
        }

        @Override
        public byte getByte() {
            byte b = (byte)((this.bytes[this.position / 8] & 255 >>> this.position % 8) << this.position % 8);
            b = this.position % 8 > 0 ? (byte)(b | (0xFF & this.bytes[this.position / 8 + 1]) >>> 8 - this.position % 8) : b;
            this.position += 8;
            return b;
        }

        @Override
        public byte getByte(int bits) {
            short mask = (short)((65280 << 8 - bits & 0xFFFF) >>> this.position % 8);
            byte b = (byte)((this.bytes[this.position / 8] & (mask & 0xFF00) >>> 8) << this.position % 8);
            if (8 - this.position % 8 < bits) {
                b = (byte)(b | (0xFF & (this.bytes[this.position / 8 + 1] & (mask & 0xFF))) >>> bits - (this.position % 8 + bits - 8));
            }
            b = (byte)((b & 0xFF) >>> 8 - bits);
            this.position += bits;
            return b;
        }

        @Override
        public void flip() {
            this.read = !this.read;
            this.position = 0;
        }

        @Override
        public boolean canRead() {
            return this.read;
        }

        @Override
        public boolean canWrite() {
            return !this.read;
        }

        @Override
        public int size() {
            return this.bytes.length;
        }

        @Override
        public int limit() {
            return this.read ? this.limit : this.bytes.length;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public BitBuffer setPosition(int newPosition) {
            this.position = newPosition;
            return this;
        }

        @Override
        public byte[] asByteArray() {
            return this.bytes;
        }
    }
}

