/*
 * Decompiled with CFR 0.152.
 */
package net.magik6k.bitbuffer;

import java.lang.reflect.Field;
import java.nio.BufferOverflowException;
import net.magik6k.bitbuffer.SimpleBitBuffer;
import sun.misc.Unsafe;

class DirectBitBuffer
extends SimpleBitBuffer {
    private final long address;
    private static Unsafe unsafe;
    private final long size;

    protected DirectBitBuffer(long bits) {
        this.address = unsafe.allocateMemory((bits + (8L - bits % 8L)) / 8L);
        unsafe.setMemory(this.address, (bits + (8L - bits % 8L)) / 8L, (byte)0);
        this.size = (bits + (8L - bits % 8L)) / 8L;
    }

    @Override
    protected byte rawGet(long index) {
        if (index >= this.size) {
            throw new BufferOverflowException();
        }
        return unsafe.getByte(this.address + index);
    }

    @Override
    protected void rawSet(long index, byte value) {
        if (index >= this.size) {
            throw new BufferOverflowException();
        }
        unsafe.putByte(this.address + index, value);
    }

    @Override
    protected long rawLength() {
        return (int)this.size;
    }

    protected void finalize() throws Throwable {
        unsafe.freeMemory(this.address);
        super.finalize();
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }
}

